package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;
import thomsonreuters.dss.api.content.enums.ValidityStatus;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AssetClassCode", 
    "AssetClassDescription", 
    "SubAssetClassCode", 
    "SubAssetClassDescription", 
    "ExpirationDate", 
    "CfiCode"})
public class OtcsSearchResult extends ValidatedInstrument implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("AssetClassCode")
    protected String assetClassCode;

    @JsonProperty("AssetClassDescription")
    protected String assetClassDescription;

    @JsonProperty("SubAssetClassCode")
    protected String subAssetClassCode;

    @JsonProperty("SubAssetClassDescription")
    protected String subAssetClassDescription;

    @JsonProperty("ExpirationDate")
    protected OffsetDateTime expirationDate;

    @JsonProperty("CfiCode")
    protected String cfiCode;

    protected OtcsSearchResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.OtcsSearchResult";
    }

    @Property(name="AssetClassCode")
    @JsonIgnore
    public Optional<String> getAssetClassCode() {
        return Optional.ofNullable(assetClassCode);
    }

    public OtcsSearchResult withAssetClassCode(String assetClassCode) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.assetClassCode = assetClassCode;
        return _x;
    }

    @Property(name="AssetClassDescription")
    @JsonIgnore
    public Optional<String> getAssetClassDescription() {
        return Optional.ofNullable(assetClassDescription);
    }

    public OtcsSearchResult withAssetClassDescription(String assetClassDescription) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.assetClassDescription = assetClassDescription;
        return _x;
    }

    @Property(name="SubAssetClassCode")
    @JsonIgnore
    public Optional<String> getSubAssetClassCode() {
        return Optional.ofNullable(subAssetClassCode);
    }

    public OtcsSearchResult withSubAssetClassCode(String subAssetClassCode) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.subAssetClassCode = subAssetClassCode;
        return _x;
    }

    @Property(name="SubAssetClassDescription")
    @JsonIgnore
    public Optional<String> getSubAssetClassDescription() {
        return Optional.ofNullable(subAssetClassDescription);
    }

    public OtcsSearchResult withSubAssetClassDescription(String subAssetClassDescription) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.subAssetClassDescription = subAssetClassDescription;
        return _x;
    }

    @Property(name="ExpirationDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public OtcsSearchResult withExpirationDate(OffsetDateTime expirationDate) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="CfiCode")
    @JsonIgnore
    public Optional<String> getCfiCode() {
        return Optional.ofNullable(cfiCode);
    }

    public OtcsSearchResult withCfiCode(String cfiCode) {
        OtcsSearchResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.OtcsSearchResult");
        _x.cfiCode = cfiCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOtcsSearchResult() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private ValidityStatus status;
        private String source;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String assetClassCode;
        private String assetClassDescription;
        private String subAssetClassCode;
        private String subAssetClassDescription;
        private OffsetDateTime expirationDate;
        private String cfiCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder status(ValidityStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder assetClassCode(String assetClassCode) {
            this.assetClassCode = assetClassCode;
            this.changedFields = changedFields.add("AssetClassCode");
            return this;
        }

        public Builder assetClassDescription(String assetClassDescription) {
            this.assetClassDescription = assetClassDescription;
            this.changedFields = changedFields.add("AssetClassDescription");
            return this;
        }

        public Builder subAssetClassCode(String subAssetClassCode) {
            this.subAssetClassCode = subAssetClassCode;
            this.changedFields = changedFields.add("SubAssetClassCode");
            return this;
        }

        public Builder subAssetClassDescription(String subAssetClassDescription) {
            this.subAssetClassDescription = subAssetClassDescription;
            this.changedFields = changedFields.add("SubAssetClassDescription");
            return this;
        }

        public Builder expirationDate(OffsetDateTime expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("ExpirationDate");
            return this;
        }

        public Builder cfiCode(String cfiCode) {
            this.cfiCode = cfiCode;
            this.changedFields = changedFields.add("CfiCode");
            return this;
        }

        public OtcsSearchResult build() {
            OtcsSearchResult _x = new OtcsSearchResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.OtcsSearchResult";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.status = status;
            _x.source = source;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.assetClassCode = assetClassCode;
            _x.assetClassDescription = assetClassDescription;
            _x.subAssetClassCode = subAssetClassCode;
            _x.subAssetClassDescription = subAssetClassDescription;
            _x.expirationDate = expirationDate;
            _x.cfiCode = cfiCode;
            return _x;
        }
    }

    private OtcsSearchResult _copy() {
        OtcsSearchResult _x = new OtcsSearchResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.status = status;
        _x.source = source;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.assetClassCode = assetClassCode;
        _x.assetClassDescription = assetClassDescription;
        _x.subAssetClassCode = subAssetClassCode;
        _x.subAssetClassDescription = subAssetClassDescription;
        _x.expirationDate = expirationDate;
        _x.cfiCode = cfiCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OtcsSearchResult[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("AssetClassCode=");
        b.append(this.assetClassCode);
        b.append(", ");
        b.append("AssetClassDescription=");
        b.append(this.assetClassDescription);
        b.append(", ");
        b.append("SubAssetClassCode=");
        b.append(this.subAssetClassCode);
        b.append(", ");
        b.append("SubAssetClassDescription=");
        b.append(this.subAssetClassDescription);
        b.append(", ");
        b.append("ExpirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("CfiCode=");
        b.append(this.cfiCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
