package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.DateTimeRange;
import thomsonreuters.dss.api.search.enums.HistoricalResultsBy;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Rics", 
    "Range", 
    "ResultsBy"})
public class ReferenceHistoryRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Rics")
    protected List<String> rics;

    @JsonProperty("Rics@nextLink")
    protected String ricsNextLink;

    @JsonProperty("Range")
    protected DateTimeRange range;

    @JsonProperty("ResultsBy")
    protected HistoricalResultsBy resultsBy;

    protected ReferenceHistoryRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest";
    }

    @Property(name="Rics")
    @JsonIgnore
    public CollectionPage<String> getRics() {
        return new CollectionPage<String>(contextPath, String.class, rics, Optional.ofNullable(ricsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Range")
    @JsonIgnore
    public Optional<DateTimeRange> getRange() {
        return Optional.ofNullable(range);
    }

    public ReferenceHistoryRequest withRange(DateTimeRange range) {
        ReferenceHistoryRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest");
        _x.range = range;
        return _x;
    }

    @Property(name="ResultsBy")
    @JsonIgnore
    public Optional<HistoricalResultsBy> getResultsBy() {
        return Optional.ofNullable(resultsBy);
    }

    public ReferenceHistoryRequest withResultsBy(HistoricalResultsBy resultsBy) {
        ReferenceHistoryRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest");
        _x.resultsBy = resultsBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> rics;
        private String ricsNextLink;
        private DateTimeRange range;
        private HistoricalResultsBy resultsBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder rics(List<String> rics) {
            this.rics = rics;
            this.changedFields = changedFields.add("Rics");
            return this;
        }

        public Builder ricsNextLink(String ricsNextLink) {
            this.ricsNextLink = ricsNextLink;
            this.changedFields = changedFields.add("Rics");
            return this;
        }

        public Builder range(DateTimeRange range) {
            this.range = range;
            this.changedFields = changedFields.add("Range");
            return this;
        }

        public Builder resultsBy(HistoricalResultsBy resultsBy) {
            this.resultsBy = resultsBy;
            this.changedFields = changedFields.add("ResultsBy");
            return this;
        }

        public ReferenceHistoryRequest build() {
            ReferenceHistoryRequest _x = new ReferenceHistoryRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest";
            _x.rics = rics;
            _x.ricsNextLink = ricsNextLink;
            _x.range = range;
            _x.resultsBy = resultsBy;
            return _x;
        }
    }

    private ReferenceHistoryRequest _copy() {
        ReferenceHistoryRequest _x = new ReferenceHistoryRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.rics = rics;
        _x.range = range;
        _x.resultsBy = resultsBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReferenceHistoryRequest[");
        b.append("Rics=");
        b.append(this.rics);
        b.append(", ");
        b.append("Range=");
        b.append(this.range);
        b.append(", ");
        b.append("ResultsBy=");
        b.append(this.resultsBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
