package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.search.complex.FidHistoryEvent;
import thomsonreuters.dss.api.search.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Ric", 
    "HistoryEvents"})
public class ReferenceHistoryResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Ric")
    protected String ric;

    @JsonProperty("HistoryEvents")
    protected List<FidHistoryEvent> historyEvents;

    @JsonProperty("HistoryEvents@nextLink")
    protected String historyEventsNextLink;

    protected ReferenceHistoryResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.ReferenceHistoryResult";
    }

    @Property(name="Ric")
    @JsonIgnore
    public Optional<String> getRic() {
        return Optional.ofNullable(ric);
    }

    public ReferenceHistoryResult withRic(String ric) {
        ReferenceHistoryResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.ReferenceHistoryResult");
        _x.ric = ric;
        return _x;
    }

    @Property(name="HistoryEvents")
    @JsonIgnore
    public CollectionPage<FidHistoryEvent> getHistoryEvents() {
        return new CollectionPage<FidHistoryEvent>(contextPath, FidHistoryEvent.class, historyEvents, Optional.ofNullable(historyEventsNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ric;
        private List<FidHistoryEvent> historyEvents;
        private String historyEventsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ric(String ric) {
            this.ric = ric;
            this.changedFields = changedFields.add("Ric");
            return this;
        }

        public Builder historyEvents(List<FidHistoryEvent> historyEvents) {
            this.historyEvents = historyEvents;
            this.changedFields = changedFields.add("HistoryEvents");
            return this;
        }

        public Builder historyEventsNextLink(String historyEventsNextLink) {
            this.historyEventsNextLink = historyEventsNextLink;
            this.changedFields = changedFields.add("HistoryEvents");
            return this;
        }

        public ReferenceHistoryResult build() {
            ReferenceHistoryResult _x = new ReferenceHistoryResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.ReferenceHistoryResult";
            _x.ric = ric;
            _x.historyEvents = historyEvents;
            _x.historyEventsNextLink = historyEventsNextLink;
            return _x;
        }
    }

    private ReferenceHistoryResult _copy() {
        ReferenceHistoryResult _x = new ReferenceHistoryResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ric = ric;
        _x.historyEvents = historyEvents;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ReferenceHistoryResult[");
        b.append("Ric=");
        b.append(this.ric);
        b.append(", ");
        b.append("HistoryEvents=");
        b.append(this.historyEvents);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
