package thomsonreuters.dss.api.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.fixedincome.usmunicipal.enums.UsMunicipalStatus;
import thomsonreuters.dss.api.content.fixedincome.usmunicipal.schema.SchemaInfo;
import thomsonreuters.dss.api.search.complex.DateComparison;
import thomsonreuters.dss.api.search.complex.NumericComparison;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AssetStatuses", 
    "CouponRate", 
    "Callable", 
    "Putable", 
    "Sinkable", 
    "IssuerDescription", 
    "MaturityDate", 
    "MoodyRatingsCodes", 
    "StandardPoorsRatingsCodes", 
    "StateCode", 
    "IdentifierType", 
    "Identifier", 
    "PreferredIdentifierType"})
public class UsMunicipalSearchRequest implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AssetStatuses")
    protected List<UsMunicipalStatus> assetStatuses;

    @JsonProperty("AssetStatuses@nextLink")
    protected String assetStatusesNextLink;

    @JsonProperty("CouponRate")
    protected NumericComparison couponRate;

    @JsonProperty("Callable")
    protected Boolean callable;

    @JsonProperty("Putable")
    protected Boolean putable;

    @JsonProperty("Sinkable")
    protected Boolean sinkable;

    @JsonProperty("IssuerDescription")
    protected String issuerDescription;

    @JsonProperty("MaturityDate")
    protected DateComparison maturityDate;

    @JsonProperty("MoodyRatingsCodes")
    protected List<String> moodyRatingsCodes;

    @JsonProperty("MoodyRatingsCodes@nextLink")
    protected String moodyRatingsCodesNextLink;

    @JsonProperty("StandardPoorsRatingsCodes")
    protected List<String> standardPoorsRatingsCodes;

    @JsonProperty("StandardPoorsRatingsCodes@nextLink")
    protected String standardPoorsRatingsCodesNextLink;

    @JsonProperty("StateCode")
    protected String stateCode;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("PreferredIdentifierType")
    protected IdentifierType preferredIdentifierType;

    protected UsMunicipalSearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest";
    }

    @Property(name="AssetStatuses")
    @JsonIgnore
    public CollectionPage<UsMunicipalStatus> getAssetStatuses() {
        return new CollectionPage<UsMunicipalStatus>(contextPath, UsMunicipalStatus.class, assetStatuses, Optional.ofNullable(assetStatusesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="CouponRate")
    @JsonIgnore
    public Optional<NumericComparison> getCouponRate() {
        return Optional.ofNullable(couponRate);
    }

    public UsMunicipalSearchRequest withCouponRate(NumericComparison couponRate) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.couponRate = couponRate;
        return _x;
    }

    @Property(name="Callable")
    @JsonIgnore
    public Optional<Boolean> getCallable() {
        return Optional.ofNullable(callable);
    }

    public UsMunicipalSearchRequest withCallable(Boolean callable) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.callable = callable;
        return _x;
    }

    @Property(name="Putable")
    @JsonIgnore
    public Optional<Boolean> getPutable() {
        return Optional.ofNullable(putable);
    }

    public UsMunicipalSearchRequest withPutable(Boolean putable) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.putable = putable;
        return _x;
    }

    @Property(name="Sinkable")
    @JsonIgnore
    public Optional<Boolean> getSinkable() {
        return Optional.ofNullable(sinkable);
    }

    public UsMunicipalSearchRequest withSinkable(Boolean sinkable) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.sinkable = sinkable;
        return _x;
    }

    @Property(name="IssuerDescription")
    @JsonIgnore
    public Optional<String> getIssuerDescription() {
        return Optional.ofNullable(issuerDescription);
    }

    public UsMunicipalSearchRequest withIssuerDescription(String issuerDescription) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.issuerDescription = issuerDescription;
        return _x;
    }

    @Property(name="MaturityDate")
    @JsonIgnore
    public Optional<DateComparison> getMaturityDate() {
        return Optional.ofNullable(maturityDate);
    }

    public UsMunicipalSearchRequest withMaturityDate(DateComparison maturityDate) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.maturityDate = maturityDate;
        return _x;
    }

    @Property(name="MoodyRatingsCodes")
    @JsonIgnore
    public CollectionPage<String> getMoodyRatingsCodes() {
        return new CollectionPage<String>(contextPath, String.class, moodyRatingsCodes, Optional.ofNullable(moodyRatingsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="StandardPoorsRatingsCodes")
    @JsonIgnore
    public CollectionPage<String> getStandardPoorsRatingsCodes() {
        return new CollectionPage<String>(contextPath, String.class, standardPoorsRatingsCodes, Optional.ofNullable(standardPoorsRatingsCodesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="StateCode")
    @JsonIgnore
    public Optional<String> getStateCode() {
        return Optional.ofNullable(stateCode);
    }

    public UsMunicipalSearchRequest withStateCode(String stateCode) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.stateCode = stateCode;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public UsMunicipalSearchRequest withIdentifierType(IdentifierType identifierType) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public UsMunicipalSearchRequest withIdentifier(String identifier) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="PreferredIdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getPreferredIdentifierType() {
        return Optional.ofNullable(preferredIdentifierType);
    }

    public UsMunicipalSearchRequest withPreferredIdentifierType(IdentifierType preferredIdentifierType) {
        UsMunicipalSearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest");
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<UsMunicipalStatus> assetStatuses;
        private String assetStatusesNextLink;
        private NumericComparison couponRate;
        private Boolean callable;
        private Boolean putable;
        private Boolean sinkable;
        private String issuerDescription;
        private DateComparison maturityDate;
        private List<String> moodyRatingsCodes;
        private String moodyRatingsCodesNextLink;
        private List<String> standardPoorsRatingsCodes;
        private String standardPoorsRatingsCodesNextLink;
        private String stateCode;
        private IdentifierType identifierType;
        private String identifier;
        private IdentifierType preferredIdentifierType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder assetStatuses(List<UsMunicipalStatus> assetStatuses) {
            this.assetStatuses = assetStatuses;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder assetStatusesNextLink(String assetStatusesNextLink) {
            this.assetStatusesNextLink = assetStatusesNextLink;
            this.changedFields = changedFields.add("AssetStatuses");
            return this;
        }

        public Builder couponRate(NumericComparison couponRate) {
            this.couponRate = couponRate;
            this.changedFields = changedFields.add("CouponRate");
            return this;
        }

        public Builder callable(Boolean callable) {
            this.callable = callable;
            this.changedFields = changedFields.add("Callable");
            return this;
        }

        public Builder putable(Boolean putable) {
            this.putable = putable;
            this.changedFields = changedFields.add("Putable");
            return this;
        }

        public Builder sinkable(Boolean sinkable) {
            this.sinkable = sinkable;
            this.changedFields = changedFields.add("Sinkable");
            return this;
        }

        public Builder issuerDescription(String issuerDescription) {
            this.issuerDescription = issuerDescription;
            this.changedFields = changedFields.add("IssuerDescription");
            return this;
        }

        public Builder maturityDate(DateComparison maturityDate) {
            this.maturityDate = maturityDate;
            this.changedFields = changedFields.add("MaturityDate");
            return this;
        }

        public Builder moodyRatingsCodes(List<String> moodyRatingsCodes) {
            this.moodyRatingsCodes = moodyRatingsCodes;
            this.changedFields = changedFields.add("MoodyRatingsCodes");
            return this;
        }

        public Builder moodyRatingsCodesNextLink(String moodyRatingsCodesNextLink) {
            this.moodyRatingsCodesNextLink = moodyRatingsCodesNextLink;
            this.changedFields = changedFields.add("MoodyRatingsCodes");
            return this;
        }

        public Builder standardPoorsRatingsCodes(List<String> standardPoorsRatingsCodes) {
            this.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
            this.changedFields = changedFields.add("StandardPoorsRatingsCodes");
            return this;
        }

        public Builder standardPoorsRatingsCodesNextLink(String standardPoorsRatingsCodesNextLink) {
            this.standardPoorsRatingsCodesNextLink = standardPoorsRatingsCodesNextLink;
            this.changedFields = changedFields.add("StandardPoorsRatingsCodes");
            return this;
        }

        public Builder stateCode(String stateCode) {
            this.stateCode = stateCode;
            this.changedFields = changedFields.add("StateCode");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder preferredIdentifierType(IdentifierType preferredIdentifierType) {
            this.preferredIdentifierType = preferredIdentifierType;
            this.changedFields = changedFields.add("PreferredIdentifierType");
            return this;
        }

        public UsMunicipalSearchRequest build() {
            UsMunicipalSearchRequest _x = new UsMunicipalSearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest";
            _x.assetStatuses = assetStatuses;
            _x.assetStatusesNextLink = assetStatusesNextLink;
            _x.couponRate = couponRate;
            _x.callable = callable;
            _x.putable = putable;
            _x.sinkable = sinkable;
            _x.issuerDescription = issuerDescription;
            _x.maturityDate = maturityDate;
            _x.moodyRatingsCodes = moodyRatingsCodes;
            _x.moodyRatingsCodesNextLink = moodyRatingsCodesNextLink;
            _x.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
            _x.standardPoorsRatingsCodesNextLink = standardPoorsRatingsCodesNextLink;
            _x.stateCode = stateCode;
            _x.identifierType = identifierType;
            _x.identifier = identifier;
            _x.preferredIdentifierType = preferredIdentifierType;
            return _x;
        }
    }

    private UsMunicipalSearchRequest _copy() {
        UsMunicipalSearchRequest _x = new UsMunicipalSearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.assetStatuses = assetStatuses;
        _x.couponRate = couponRate;
        _x.callable = callable;
        _x.putable = putable;
        _x.sinkable = sinkable;
        _x.issuerDescription = issuerDescription;
        _x.maturityDate = maturityDate;
        _x.moodyRatingsCodes = moodyRatingsCodes;
        _x.standardPoorsRatingsCodes = standardPoorsRatingsCodes;
        _x.stateCode = stateCode;
        _x.identifierType = identifierType;
        _x.identifier = identifier;
        _x.preferredIdentifierType = preferredIdentifierType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UsMunicipalSearchRequest[");
        b.append("AssetStatuses=");
        b.append(this.assetStatuses);
        b.append(", ");
        b.append("CouponRate=");
        b.append(this.couponRate);
        b.append(", ");
        b.append("Callable=");
        b.append(this.callable);
        b.append(", ");
        b.append("Putable=");
        b.append(this.putable);
        b.append(", ");
        b.append("Sinkable=");
        b.append(this.sinkable);
        b.append(", ");
        b.append("IssuerDescription=");
        b.append(this.issuerDescription);
        b.append(", ");
        b.append("MaturityDate=");
        b.append(this.maturityDate);
        b.append(", ");
        b.append("MoodyRatingsCodes=");
        b.append(this.moodyRatingsCodes);
        b.append(", ");
        b.append("StandardPoorsRatingsCodes=");
        b.append(this.standardPoorsRatingsCodes);
        b.append(", ");
        b.append("StateCode=");
        b.append(this.stateCode);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("PreferredIdentifierType=");
        b.append(this.preferredIdentifierType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
