package thomsonreuters.dss.api.search.container;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.TestingService.BuilderBase;
import com.github.davidmoten.odata.client.TestingService.ContainerBuilder;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import thomsonreuters.dss.api.content.complex.AssetCategory;
import thomsonreuters.dss.api.content.complex.Country;
import thomsonreuters.dss.api.content.complex.Currency;
import thomsonreuters.dss.api.content.complex.Exchange;
import thomsonreuters.dss.api.content.complex.FileCode;
import thomsonreuters.dss.api.content.complex.GicsIndustryClassification;
import thomsonreuters.dss.api.content.complex.IndustrySector;
import thomsonreuters.dss.api.content.complex.InstrumentSubType;
import thomsonreuters.dss.api.content.complex.MoodyRating;
import thomsonreuters.dss.api.content.complex.StandardAndPoorsRating;
import thomsonreuters.dss.api.content.complex.State;
import thomsonreuters.dss.api.content.complex.TrBusinessClassification;
import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.complex.ValidatedInstrument;
import thomsonreuters.dss.api.content.equity.complex.EquitySubType;
import thomsonreuters.dss.api.content.fixedincome.cmoabs.complex.CmoAbsSubGroupType;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpAssetStatus;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpContributor;
import thomsonreuters.dss.api.content.fixedincome.govcorp.complex.GovCorpSubGroup;
import thomsonreuters.dss.api.content.fixedincome.mortgage.complex.MortgageAgency;
import thomsonreuters.dss.api.content.fixedincome.mortgage.complex.MortgagePoolType;
import thomsonreuters.dss.api.search.complex.AllInstrumentSearchRequest;
import thomsonreuters.dss.api.search.complex.BenchmarkSearchRequest;
import thomsonreuters.dss.api.search.complex.BenchmarkSearchResult;
import thomsonreuters.dss.api.search.complex.CmoAbsSearchRequest;
import thomsonreuters.dss.api.search.complex.CommoditySearchRequest;
import thomsonreuters.dss.api.search.complex.CommoditySearchResult;
import thomsonreuters.dss.api.search.complex.EntitySearchRequest;
import thomsonreuters.dss.api.search.complex.EquitySearchRequest;
import thomsonreuters.dss.api.search.complex.EquitySearchResult;
import thomsonreuters.dss.api.search.complex.FundSearchRequest;
import thomsonreuters.dss.api.search.complex.FundSearchResult;
import thomsonreuters.dss.api.search.complex.FuturesAndOptionsSearchRequest;
import thomsonreuters.dss.api.search.complex.FuturesAndOptionsSearchResult;
import thomsonreuters.dss.api.search.complex.GovCorpSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalBulkSearchResult;
import thomsonreuters.dss.api.search.complex.HistoricalChainInstrument;
import thomsonreuters.dss.api.search.complex.HistoricalChainResolutionRequest;
import thomsonreuters.dss.api.search.complex.HistoricalCriteriaSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalLookupEntry;
import thomsonreuters.dss.api.search.complex.HistoricalSearchRequest;
import thomsonreuters.dss.api.search.complex.HistoricalSearchResult;
import thomsonreuters.dss.api.search.complex.MifidSubclassSearchRequest;
import thomsonreuters.dss.api.search.complex.MifidSubclassSearchResult;
import thomsonreuters.dss.api.search.complex.MortgageSearchRequest;
import thomsonreuters.dss.api.search.complex.OtcsSearchRequest;
import thomsonreuters.dss.api.search.complex.OtcsSearchResult;
import thomsonreuters.dss.api.search.complex.ReferenceHistoryRequest;
import thomsonreuters.dss.api.search.complex.ReferenceHistoryResult;
import thomsonreuters.dss.api.search.complex.UsMunicipalSearchRequest;

public final class Search implements HasContext {

    private final ContextPath contextPath;

    public Search(Context context) {
        this.contextPath = new ContextPath(context, context.service().getBasePath());
    }

    @Override
    public Context _context() {
        return contextPath.context();
    }

    public HttpService _service() {
        return contextPath.context().service();
    }

    static final class ContainerBuilderImpl extends ContainerBuilder<Search> {

        @Override
        public Search _create(Context context) {
            return new Search(context);
        }
    }

    public static BuilderBase<ContainerBuilder<Search>, Search> test() {
        return new ContainerBuilderImpl();
    }

    @Action(name = "InstrumentSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> instrumentSearch(AllInstrumentSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.AllInstrumentSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.InstrumentSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "EquitySearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EquitySearchResult> equitySearch(EquitySearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.EquitySearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.EquitySearch"), EquitySearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "FuturesAndOptionsSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FuturesAndOptionsSearchResult> futuresAndOptionsSearch(FuturesAndOptionsSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.FuturesAndOptionsSearch"), FuturesAndOptionsSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "BenchmarkSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<BenchmarkSearchResult> benchmarkSearch(BenchmarkSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.BenchmarkSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.BenchmarkSearch"), BenchmarkSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "GovCorpSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> govCorpSearch(GovCorpSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.GovCorpSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GovCorpSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "EntitySearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedEntity> entitySearch(EntitySearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.EntitySearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.EntitySearch"), ValidatedEntity.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "FundSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FundSearchResult> fundSearch(FundSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.FundSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.FundSearch"), FundSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "CommoditySearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CommoditySearchResult> commoditySearch(CommoditySearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.CommoditySearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.CommoditySearch"), CommoditySearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "MortgageSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> mortgageSearch(MortgageSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.MortgageSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.MortgageSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "UsMunicipalSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> usMunicipalSearch(UsMunicipalSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.UsMunicipalSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.UsMunicipalSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "CmoAbsSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ValidatedInstrument> cmoAbsSearch(CmoAbsSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.CmoAbsSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.CmoAbsSearch"), ValidatedInstrument.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "MifidSubclassSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MifidSubclassSearchResult> mifidSubclassSearch(MifidSubclassSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.MifidSubclassSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.MifidSubclassSearch"), MifidSubclassSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "OtcsSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OtcsSearchResult> otcsSearch(OtcsSearchRequest searchRequest) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SearchRequest", "ThomsonReuters.Dss.Api.Search.OtcsSearchRequest", searchRequest)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.OtcsSearch"), OtcsSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "HistoricalSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalSearchResult> historicalSearch(HistoricalSearchRequest request) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Request", "ThomsonReuters.Dss.Api.Search.HistoricalSearchRequest", request)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.HistoricalSearch"), HistoricalSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "HistoricalBulkSearch")
    @JsonIgnore
    public ActionRequestReturningNonCollection<HistoricalBulkSearchResult> historicalBulkSearch(HistoricalBulkSearchRequest request) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Request", "ThomsonReuters.Dss.Api.Search.HistoricalBulkSearchRequest", request)
            .build();
        return new ActionRequestReturningNonCollection<HistoricalBulkSearchResult>(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.HistoricalBulkSearch"), HistoricalBulkSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "HistoricalCriteriaSearch")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalSearchResult> historicalCriteriaSearch(HistoricalCriteriaSearchRequest request) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Request", "ThomsonReuters.Dss.Api.Search.HistoricalCriteriaSearchRequest", request)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.HistoricalCriteriaSearch"), HistoricalSearchResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "HistoricalChainResolution")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalChainInstrument> historicalChainResolution(HistoricalChainResolutionRequest request) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Request", "ThomsonReuters.Dss.Api.Search.HistoricalChainResolutionRequest", request)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.HistoricalChainResolution"), HistoricalChainInstrument.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "ReferenceHistory")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ReferenceHistoryResult> referenceHistory(ReferenceHistoryRequest request) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Request", "ThomsonReuters.Dss.Api.Search.ReferenceHistoryRequest", request)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.ReferenceHistory"), ReferenceHistoryResult.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalBondTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalBondTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalBondTypes"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalCountries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalCountries() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalCountries"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalCurrencies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalCurrencies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalCurrencies"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalDomains")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalDomains() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalDomains"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalExchanges")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalExchanges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalExchanges"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalFutureMonths")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalFutureMonths() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalFutureMonths"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalInstrumentTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalInstrumentTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalInstrumentTypes"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalOptionTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalOptionTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalOptionTypes"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetHistoricalOptionMonths")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HistoricalLookupEntry> getHistoricalOptionMonths() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetHistoricalOptionMonths"), HistoricalLookupEntry.class, _parameters, thomsonreuters.dss.api.search.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetGicsIndustryClassifications")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GicsIndustryClassification> getGicsIndustryClassifications() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetGicsIndustryClassifications"), GicsIndustryClassification.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetExchanges")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Exchange> getExchanges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetExchanges"), Exchange.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetCountries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Country> getCountries() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetCountries"), Country.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetStates")
    @JsonIgnore
    public CollectionPageNonEntityRequest<State> getStates() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetStates"), State.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetCurrencies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Currency> getCurrencies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetCurrencies"), Currency.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetFileCodes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<FileCode> getFileCodes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetFileCodes"), FileCode.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetTrBusinessClassifications")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TrBusinessClassification> getTrBusinessClassifications() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetTrBusinessClassifications"), TrBusinessClassification.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetGovCorpContributors")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GovCorpContributor> getGovCorpContributors() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetGovCorpContributors"), GovCorpContributor.class, _parameters, thomsonreuters.dss.api.content.fixedincome.govcorp.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetIndustrySectors")
    @JsonIgnore
    public CollectionPageNonEntityRequest<IndustrySector> getIndustrySectors() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetIndustrySectors"), IndustrySector.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetEquitySubTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EquitySubType> getEquitySubTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetEquitySubTypes"), EquitySubType.class, _parameters, thomsonreuters.dss.api.content.equity.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetMoodyRatings")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MoodyRating> getMoodyRatings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetMoodyRatings"), MoodyRating.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetStandardAndPoorsRatings")
    @JsonIgnore
    public CollectionPageNonEntityRequest<StandardAndPoorsRating> getStandardAndPoorsRatings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetStandardAndPoorsRatings"), StandardAndPoorsRating.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetMortgageAgencies")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MortgageAgency> getMortgageAgencies() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetMortgageAgencies"), MortgageAgency.class, _parameters, thomsonreuters.dss.api.content.fixedincome.mortgage.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetMortgagePoolTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MortgagePoolType> getMortgagePoolTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetMortgagePoolTypes"), MortgagePoolType.class, _parameters, thomsonreuters.dss.api.content.fixedincome.mortgage.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetCmoAbsSubGroupTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CmoAbsSubGroupType> getCmoAbsSubGroupTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetCmoAbsSubGroupTypes"), CmoAbsSubGroupType.class, _parameters, thomsonreuters.dss.api.content.fixedincome.cmoabs.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetAssetCategories")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AssetCategory> getAssetCategories() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetAssetCategories"), AssetCategory.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetInstrumentSubTypes")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InstrumentSubType> getInstrumentSubTypes() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetInstrumentSubTypes"), InstrumentSubType.class, _parameters, thomsonreuters.dss.api.content.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetGovCorpAssetStatuses")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GovCorpAssetStatus> getGovCorpAssetStatuses() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetGovCorpAssetStatuses"), GovCorpAssetStatus.class, _parameters, thomsonreuters.dss.api.content.fixedincome.govcorp.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "GetGovCorpSubGroups")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GovCorpSubGroup> getGovCorpSubGroups() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addSegment("ThomsonReuters.Dss.Api.Search.GetGovCorpSubGroups"), GovCorpSubGroup.class, _parameters, thomsonreuters.dss.api.content.fixedincome.govcorp.schema.SchemaInfo.INSTANCE);
    }

}
