package thomsonreuters.dss.api.search.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ComparisonOperator implements Enum {

    @JsonProperty("Equals")
    EQUALS("Equals", "0"),

    @JsonProperty("NotEquals")
    NOT_EQUALS("NotEquals", "1"),

    @JsonProperty("LessThan")
    LESS_THAN("LessThan", "2"),

    @JsonProperty("LessThanEquals")
    LESS_THAN_EQUALS("LessThanEquals", "3"),

    @JsonProperty("GreaterThan")
    GREATER_THAN("GreaterThan", "4"),

    @JsonProperty("GreaterThanEquals")
    GREATER_THAN_EQUALS("GreaterThanEquals", "5");

    private final String name;
    private final String value;

    private ComparisonOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
