package thomsonreuters.dss.api.search.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum SetMembershipOperator implements Enum {

    @JsonProperty("Include")
    INCLUDE("Include", "0"),

    @JsonProperty("Exclude")
    EXCLUDE("Exclude", "1");

    private final String name;
    private final String value;

    private SetMembershipOperator(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
