/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.client;

import java.util.List;
import java.util.Optional;
import org.davidmoten.oa3.codegen.client.runtime.ClientBuilder;
import org.davidmoten.oa3.codegen.http.Http;
import org.davidmoten.oa3.codegen.http.HttpMethod;
import org.davidmoten.oa3.codegen.http.HttpResponse;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.Item;
import org.davidmoten.oa3.codegen.test.library.schema.User;
import org.davidmoten.oa3.codegen.test.library.schema.UsersPage;

public class Client {
    private final Serializer serializer;
    private final List<Interceptor> interceptors;
    private final String basePath;

    private Client(Serializer serializer, List<Interceptor> interceptors, String basePath) {
        this.serializer = serializer;
        this.interceptors = interceptors;
        this.basePath = basePath;
    }

    public static ClientBuilder<Client> basePath(String basePath) {
        return new ClientBuilder(b -> new Client(b.serializer(), b.interceptors(), b.basePath()), Globals.config(), basePath);
    }

    public UsersPage getUsers(Optional<String> search, Optional<String> continuationToken) {
        return (UsersPage)this.getUsersFullResponse(search, continuationToken).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getUsersFullResponse(Optional<String> search, Optional<String> continuationToken) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/user").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().queryParam("search", search).queryParam("continuationToken", continuationToken).responseAs(UsersPage.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").call();
    }

    public HttpResponse createUserFullResponse(User requestBody) {
        return Http.method((HttpMethod)HttpMethod.POST).basePath(this.basePath).path("/user").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().body((Object)requestBody).contentTypeApplicationJson().call();
    }

    public User getUser(String id) {
        return (User)this.getUserFullResponse(id).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getUserFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/user/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).responseAs(User.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").call();
    }

    public HttpResponse updateUserFullResponse(String id, User requestBody) {
        return Http.method((HttpMethod)HttpMethod.PUT).basePath(this.basePath).path("/user/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).body((Object)requestBody).contentTypeApplicationJson().call();
    }

    public HttpResponse deleteUserFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.DELETE).basePath(this.basePath).path("/user/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).call();
    }

    public Item getItem(String itemId) {
        return (Item)this.getItemFullResponse(itemId).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getItemFullResponse(String itemId) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/item/{itemId}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("itemId", (Object)itemId).responseAs(Item.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").call();
    }
}

