/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.Book;
import org.davidmoten.oa3.codegen.test.library.schema.PersonName;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Audiobook {
    @JsonProperty(value="book")
    private final Book book;
    @JsonProperty(value="voices")
    private final Voices voices;
    @JsonProperty(value="lengthMinutes")
    private final Double lengthMinutes;

    @JsonCreator
    private Audiobook(@JsonProperty(value="book") Book book, @JsonProperty(value="voices") Voices voices, @JsonProperty(value="lengthMinutes") Double lengthMinutes) {
        if (Globals.config().validateInConstructor().test(Audiobook.class)) {
            Preconditions.checkMinimum((Number)lengthMinutes, (String)"0", (String)"lengthMinutes", (boolean)false);
        }
        this.book = book;
        this.voices = voices;
        this.lengthMinutes = lengthMinutes;
    }

    @ConstructorBinding
    public Audiobook(Book book, Voices voices, Optional<Double> lengthMinutes) {
        if (Globals.config().validateInConstructor().test(Audiobook.class)) {
            Preconditions.checkNotNull((Object)book, (String)"book");
            Preconditions.checkNotNull((Object)voices, (String)"voices");
            Preconditions.checkNotNull(lengthMinutes, (String)"lengthMinutes");
            Preconditions.checkMinimum(lengthMinutes, (String)"0", (String)"lengthMinutes", (boolean)false);
        }
        this.book = book;
        this.voices = voices;
        this.lengthMinutes = lengthMinutes.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Book book() {
        return this.book;
    }

    public Voices voices() {
        return this.voices;
    }

    public Optional<Double> lengthMinutes() {
        return Optional.ofNullable(this.lengthMinutes);
    }

    public Audiobook withBook(Book book) {
        return new Audiobook(book, this.voices, Optional.ofNullable(this.lengthMinutes));
    }

    public Audiobook withVoices(Voices voices) {
        return new Audiobook(this.book, voices, Optional.ofNullable(this.lengthMinutes));
    }

    public Audiobook withLengthMinutes(Optional<Double> lengthMinutes) {
        return new Audiobook(this.book, this.voices, lengthMinutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Audiobook other = (Audiobook)o;
        return Objects.equals(this.book, other.book) && Objects.equals(this.voices, other.voices) && Objects.equals(this.lengthMinutes, other.lengthMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.book, this.voices, this.lengthMinutes);
    }

    public String toString() {
        return Util.toString(Audiobook.class, (Object[])new Object[]{"book", this.book, "voices", this.voices, "lengthMinutes", this.lengthMinutes});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Voices {
        @JsonValue
        private final List<PersonName> value;

        @JsonCreator
        @ConstructorBinding
        public Voices(List<PersonName> value) {
            if (Globals.config().validateInConstructor().test(Voices.class)) {
                Preconditions.checkNotNull(value, (String)"value");
                Preconditions.checkMinSize(value, (int)1, (String)"value");
            }
            this.value = value;
        }

        public static Voices value(List<PersonName> value) {
            return new Voices(value);
        }

        public List<PersonName> value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Voices other = (Voices)o;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return Util.toString(Voices.class, (Object[])new Object[]{"value", this.value});
        }
    }

    public static final class BuilderWithVoices {
        private final Builder b;

        BuilderWithVoices(Builder b) {
            this.b = b;
        }

        public BuilderWithVoices lengthMinutes(double lengthMinutes) {
            this.b.lengthMinutes = Optional.of(lengthMinutes);
            return this;
        }

        public BuilderWithVoices lengthMinutes(Optional<Double> lengthMinutes) {
            this.b.lengthMinutes = lengthMinutes;
            return this;
        }

        public Audiobook build() {
            return new Audiobook(this.b.book, this.b.voices, this.b.lengthMinutes);
        }
    }

    public static final class BuilderWithBook {
        private final Builder b;

        BuilderWithBook(Builder b) {
            this.b = b;
        }

        public BuilderWithVoices voices(Voices voices) {
            this.b.voices = voices;
            return new BuilderWithVoices(this.b);
        }
    }

    public static final class Builder {
        private Book book;
        private Voices voices;
        private Optional<Double> lengthMinutes = Optional.empty();

        Builder() {
        }

        public BuilderWithBook book(Book book) {
            this.book = book;
            return new BuilderWithBook(this);
        }
    }
}

