/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.Abstract;
import org.davidmoten.oa3.codegen.test.library.schema.ISBN;
import org.davidmoten.oa3.codegen.test.library.schema.Id;
import org.davidmoten.oa3.codegen.test.library.schema.ItemId;
import org.davidmoten.oa3.codegen.test.library.schema.Language;
import org.davidmoten.oa3.codegen.test.library.schema.PersonName;
import org.davidmoten.oa3.codegen.test.library.schema.Year;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Book {
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="author")
    private final PersonName author;
    @JsonProperty(value="abstract")
    private final Abstract abstract_;
    @JsonProperty(value="publishedYear")
    private final Year publishedYear;
    @JsonProperty(value="authorId")
    private final Id authorId;
    @JsonProperty(value="isbn")
    private final ISBN isbn;
    @JsonProperty(value="itemId")
    private final ItemId itemId;
    @JsonProperty(value="language")
    private final Language language;

    @JsonCreator
    private Book(@JsonProperty(value="title") String title, @JsonProperty(value="author") PersonName author, @JsonProperty(value="abstract") Abstract abstract_, @JsonProperty(value="publishedYear") Year publishedYear, @JsonProperty(value="authorId") Id authorId, @JsonProperty(value="isbn") ISBN isbn, @JsonProperty(value="itemId") ItemId itemId, @JsonProperty(value="language") Language language) {
        this.title = title;
        this.author = author;
        this.abstract_ = abstract_;
        this.publishedYear = publishedYear;
        this.authorId = authorId;
        this.isbn = isbn;
        this.itemId = itemId;
        this.language = language;
    }

    @ConstructorBinding
    public Book(String title, PersonName author, Optional<Abstract> abstract_, Year publishedYear, Id authorId, ISBN isbn, ItemId itemId, Language language) {
        if (Globals.config().validateInConstructor().test(Book.class)) {
            Preconditions.checkNotNull((Object)title, (String)"title");
            Preconditions.checkNotNull((Object)author, (String)"author");
            Preconditions.checkNotNull(abstract_, (String)"abstract_");
            Preconditions.checkNotNull((Object)publishedYear, (String)"publishedYear");
            Preconditions.checkNotNull((Object)authorId, (String)"authorId");
            Preconditions.checkNotNull((Object)isbn, (String)"isbn");
            Preconditions.checkNotNull((Object)itemId, (String)"itemId");
            Preconditions.checkNotNull((Object)((Object)language), (String)"language");
        }
        this.title = title;
        this.author = author;
        this.abstract_ = abstract_.orElse(null);
        this.publishedYear = publishedYear;
        this.authorId = authorId;
        this.isbn = isbn;
        this.itemId = itemId;
        this.language = language;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String title() {
        return this.title;
    }

    public PersonName author() {
        return this.author;
    }

    public Optional<Abstract> abstract_() {
        return Optional.ofNullable(this.abstract_);
    }

    public Year publishedYear() {
        return this.publishedYear;
    }

    public Id authorId() {
        return this.authorId;
    }

    public ISBN isbn() {
        return this.isbn;
    }

    public ItemId itemId() {
        return this.itemId;
    }

    public Language language() {
        return this.language;
    }

    public Book withTitle(String title) {
        return new Book(title, this.author, Optional.ofNullable(this.abstract_), this.publishedYear, this.authorId, this.isbn, this.itemId, this.language);
    }

    public Book withAuthor(PersonName author) {
        return new Book(this.title, author, Optional.ofNullable(this.abstract_), this.publishedYear, this.authorId, this.isbn, this.itemId, this.language);
    }

    public Book withAbstract_(Optional<Abstract> abstract_) {
        return new Book(this.title, this.author, abstract_, this.publishedYear, this.authorId, this.isbn, this.itemId, this.language);
    }

    public Book withPublishedYear(Year publishedYear) {
        return new Book(this.title, this.author, Optional.ofNullable(this.abstract_), publishedYear, this.authorId, this.isbn, this.itemId, this.language);
    }

    public Book withAuthorId(Id authorId) {
        return new Book(this.title, this.author, Optional.ofNullable(this.abstract_), this.publishedYear, authorId, this.isbn, this.itemId, this.language);
    }

    public Book withIsbn(ISBN isbn) {
        return new Book(this.title, this.author, Optional.ofNullable(this.abstract_), this.publishedYear, this.authorId, isbn, this.itemId, this.language);
    }

    public Book withItemId(ItemId itemId) {
        return new Book(this.title, this.author, Optional.ofNullable(this.abstract_), this.publishedYear, this.authorId, this.isbn, itemId, this.language);
    }

    public Book withLanguage(Language language) {
        return new Book(this.title, this.author, Optional.ofNullable(this.abstract_), this.publishedYear, this.authorId, this.isbn, this.itemId, language);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book other = (Book)o;
        return Objects.equals(this.title, other.title) && Objects.equals(this.author, other.author) && Objects.equals(this.abstract_, other.abstract_) && Objects.equals(this.publishedYear, other.publishedYear) && Objects.equals(this.authorId, other.authorId) && Objects.equals(this.isbn, other.isbn) && Objects.equals(this.itemId, other.itemId) && Objects.equals((Object)this.language, (Object)other.language);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.author, this.abstract_, this.publishedYear, this.authorId, this.isbn, this.itemId, this.language});
    }

    public String toString() {
        return Util.toString(Book.class, (Object[])new Object[]{"title", this.title, "author", this.author, "abstract_", this.abstract_, "publishedYear", this.publishedYear, "authorId", this.authorId, "isbn", this.isbn, "itemId", this.itemId, "language", this.language});
    }

    public static final class BuilderWithLanguage {
        private final Builder b;

        BuilderWithLanguage(Builder b) {
            this.b = b;
        }

        public BuilderWithLanguage abstract_(Abstract abstract_) {
            this.b.abstract_ = Optional.of(abstract_);
            return this;
        }

        public BuilderWithLanguage abstract_(Optional<Abstract> abstract_) {
            this.b.abstract_ = abstract_;
            return this;
        }

        public Book build() {
            return new Book(this.b.title, this.b.author, this.b.abstract_, this.b.publishedYear, this.b.authorId, this.b.isbn, this.b.itemId, this.b.language);
        }
    }

    public static final class BuilderWithItemId {
        private final Builder b;

        BuilderWithItemId(Builder b) {
            this.b = b;
        }

        public BuilderWithLanguage language(Language language) {
            this.b.language = language;
            return new BuilderWithLanguage(this.b);
        }
    }

    public static final class BuilderWithIsbn {
        private final Builder b;

        BuilderWithIsbn(Builder b) {
            this.b = b;
        }

        public BuilderWithItemId itemId(ItemId itemId) {
            this.b.itemId = itemId;
            return new BuilderWithItemId(this.b);
        }
    }

    public static final class BuilderWithAuthorId {
        private final Builder b;

        BuilderWithAuthorId(Builder b) {
            this.b = b;
        }

        public BuilderWithIsbn isbn(ISBN isbn) {
            this.b.isbn = isbn;
            return new BuilderWithIsbn(this.b);
        }
    }

    public static final class BuilderWithPublishedYear {
        private final Builder b;

        BuilderWithPublishedYear(Builder b) {
            this.b = b;
        }

        public BuilderWithAuthorId authorId(Id authorId) {
            this.b.authorId = authorId;
            return new BuilderWithAuthorId(this.b);
        }
    }

    public static final class BuilderWithAuthor {
        private final Builder b;

        BuilderWithAuthor(Builder b) {
            this.b = b;
        }

        public BuilderWithPublishedYear publishedYear(Year publishedYear) {
            this.b.publishedYear = publishedYear;
            return new BuilderWithPublishedYear(this.b);
        }
    }

    public static final class BuilderWithTitle {
        private final Builder b;

        BuilderWithTitle(Builder b) {
            this.b = b;
        }

        public BuilderWithAuthor author(PersonName author) {
            this.b.author = author;
            return new BuilderWithAuthor(this.b);
        }
    }

    public static final class Builder {
        private String title;
        private PersonName author;
        private Year publishedYear;
        private Id authorId;
        private ISBN isbn;
        private ItemId itemId;
        private Language language;
        private Optional<Abstract> abstract_ = Optional.empty();

        Builder() {
        }

        public BuilderWithTitle title(String title) {
            this.title = title;
            return new BuilderWithTitle(this);
        }
    }
}

