/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.ItemId;
import org.davidmoten.oa3.codegen.test.library.schema.UserId;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Loan {
    @JsonProperty(value="userId")
    private final UserId userId;
    @JsonProperty(value="itemId")
    private final ItemId itemId;
    @JsonProperty(value="startDate")
    private final LocalDate startDate;
    @JsonProperty(value="dueDate")
    private final LocalDate dueDate;
    @JsonProperty(value="dateReturned")
    private final LocalDate dateReturned;

    @JsonCreator
    private Loan(@JsonProperty(value="userId") UserId userId, @JsonProperty(value="itemId") ItemId itemId, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="dueDate") LocalDate dueDate, @JsonProperty(value="dateReturned") LocalDate dateReturned) {
        this.userId = userId;
        this.itemId = itemId;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.dateReturned = dateReturned;
    }

    @ConstructorBinding
    public Loan(UserId userId, ItemId itemId, LocalDate startDate, LocalDate dueDate, Optional<LocalDate> dateReturned) {
        if (Globals.config().validateInConstructor().test(Loan.class)) {
            Preconditions.checkNotNull((Object)userId, (String)"userId");
            Preconditions.checkNotNull((Object)itemId, (String)"itemId");
            Preconditions.checkNotNull((Object)startDate, (String)"startDate");
            Preconditions.checkNotNull((Object)dueDate, (String)"dueDate");
            Preconditions.checkNotNull(dateReturned, (String)"dateReturned");
        }
        this.userId = userId;
        this.itemId = itemId;
        this.startDate = startDate;
        this.dueDate = dueDate;
        this.dateReturned = dateReturned.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public UserId userId() {
        return this.userId;
    }

    public ItemId itemId() {
        return this.itemId;
    }

    public LocalDate startDate() {
        return this.startDate;
    }

    public LocalDate dueDate() {
        return this.dueDate;
    }

    public Optional<LocalDate> dateReturned() {
        return Optional.ofNullable(this.dateReturned);
    }

    public Loan withUserId(UserId userId) {
        return new Loan(userId, this.itemId, this.startDate, this.dueDate, Optional.ofNullable(this.dateReturned));
    }

    public Loan withItemId(ItemId itemId) {
        return new Loan(this.userId, itemId, this.startDate, this.dueDate, Optional.ofNullable(this.dateReturned));
    }

    public Loan withStartDate(LocalDate startDate) {
        return new Loan(this.userId, this.itemId, startDate, this.dueDate, Optional.ofNullable(this.dateReturned));
    }

    public Loan withDueDate(LocalDate dueDate) {
        return new Loan(this.userId, this.itemId, this.startDate, dueDate, Optional.ofNullable(this.dateReturned));
    }

    public Loan withDateReturned(Optional<LocalDate> dateReturned) {
        return new Loan(this.userId, this.itemId, this.startDate, this.dueDate, dateReturned);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Loan other = (Loan)o;
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.itemId, other.itemId) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.dueDate, other.dueDate) && Objects.equals(this.dateReturned, other.dateReturned);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.itemId, this.startDate, this.dueDate, this.dateReturned);
    }

    public String toString() {
        return Util.toString(Loan.class, (Object[])new Object[]{"userId", this.userId, "itemId", this.itemId, "startDate", this.startDate, "dueDate", this.dueDate, "dateReturned", this.dateReturned});
    }

    public static final class BuilderWithDueDate {
        private final Builder b;

        BuilderWithDueDate(Builder b) {
            this.b = b;
        }

        public BuilderWithDueDate dateReturned(LocalDate dateReturned) {
            this.b.dateReturned = Optional.of(dateReturned);
            return this;
        }

        public BuilderWithDueDate dateReturned(Optional<LocalDate> dateReturned) {
            this.b.dateReturned = dateReturned;
            return this;
        }

        public Loan build() {
            return new Loan(this.b.userId, this.b.itemId, this.b.startDate, this.b.dueDate, this.b.dateReturned);
        }
    }

    public static final class BuilderWithStartDate {
        private final Builder b;

        BuilderWithStartDate(Builder b) {
            this.b = b;
        }

        public BuilderWithDueDate dueDate(LocalDate dueDate) {
            this.b.dueDate = dueDate;
            return new BuilderWithDueDate(this.b);
        }
    }

    public static final class BuilderWithItemId {
        private final Builder b;

        BuilderWithItemId(Builder b) {
            this.b = b;
        }

        public BuilderWithStartDate startDate(LocalDate startDate) {
            this.b.startDate = startDate;
            return new BuilderWithStartDate(this.b);
        }
    }

    public static final class BuilderWithUserId {
        private final Builder b;

        BuilderWithUserId(Builder b) {
            this.b = b;
        }

        public BuilderWithItemId itemId(ItemId itemId) {
            this.b.itemId = itemId;
            return new BuilderWithItemId(this.b);
        }
    }

    public static final class Builder {
        private UserId userId;
        private ItemId itemId;
        private LocalDate startDate;
        private LocalDate dueDate;
        private Optional<LocalDate> dateReturned = Optional.empty();

        Builder() {
        }

        public BuilderWithUserId userId(UserId userId) {
            this.userId = userId;
            return new BuilderWithUserId(this);
        }
    }
}

