/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.Abstract;
import org.davidmoten.oa3.codegen.test.library.schema.ISSN;
import org.davidmoten.oa3.codegen.test.library.schema.Id;
import org.davidmoten.oa3.codegen.test.library.schema.ItemId;
import org.davidmoten.oa3.codegen.test.library.schema.Language;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Serial {
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="abstract")
    private final Abstract abstract_;
    @JsonProperty(value="publishedDate")
    private final LocalDate publishedDate;
    @JsonProperty(value="publisherId")
    private final Id publisherId;
    @JsonProperty(value="issn")
    private final ISSN issn;
    @JsonProperty(value="itemId")
    private final ItemId itemId;
    @JsonProperty(value="language")
    private final Language language;

    @JsonCreator
    private Serial(@JsonProperty(value="title") String title, @JsonProperty(value="abstract") Abstract abstract_, @JsonProperty(value="publishedDate") LocalDate publishedDate, @JsonProperty(value="publisherId") Id publisherId, @JsonProperty(value="issn") ISSN issn, @JsonProperty(value="itemId") ItemId itemId, @JsonProperty(value="language") Language language) {
        this.title = title;
        this.abstract_ = abstract_;
        this.publishedDate = publishedDate;
        this.publisherId = publisherId;
        this.issn = issn;
        this.itemId = itemId;
        this.language = language;
    }

    @ConstructorBinding
    public Serial(String title, Optional<Abstract> abstract_, LocalDate publishedDate, Id publisherId, ISSN issn, ItemId itemId, Language language) {
        if (Globals.config().validateInConstructor().test(Serial.class)) {
            Preconditions.checkNotNull((Object)title, (String)"title");
            Preconditions.checkNotNull(abstract_, (String)"abstract_");
            Preconditions.checkNotNull((Object)publishedDate, (String)"publishedDate");
            Preconditions.checkNotNull((Object)publisherId, (String)"publisherId");
            Preconditions.checkNotNull((Object)issn, (String)"issn");
            Preconditions.checkNotNull((Object)itemId, (String)"itemId");
            Preconditions.checkNotNull((Object)((Object)language), (String)"language");
        }
        this.title = title;
        this.abstract_ = abstract_.orElse(null);
        this.publishedDate = publishedDate;
        this.publisherId = publisherId;
        this.issn = issn;
        this.itemId = itemId;
        this.language = language;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String title() {
        return this.title;
    }

    public Optional<Abstract> abstract_() {
        return Optional.ofNullable(this.abstract_);
    }

    public LocalDate publishedDate() {
        return this.publishedDate;
    }

    public Id publisherId() {
        return this.publisherId;
    }

    public ISSN issn() {
        return this.issn;
    }

    public ItemId itemId() {
        return this.itemId;
    }

    public Language language() {
        return this.language;
    }

    public Serial withTitle(String title) {
        return new Serial(title, Optional.ofNullable(this.abstract_), this.publishedDate, this.publisherId, this.issn, this.itemId, this.language);
    }

    public Serial withAbstract_(Optional<Abstract> abstract_) {
        return new Serial(this.title, abstract_, this.publishedDate, this.publisherId, this.issn, this.itemId, this.language);
    }

    public Serial withPublishedDate(LocalDate publishedDate) {
        return new Serial(this.title, Optional.ofNullable(this.abstract_), publishedDate, this.publisherId, this.issn, this.itemId, this.language);
    }

    public Serial withPublisherId(Id publisherId) {
        return new Serial(this.title, Optional.ofNullable(this.abstract_), this.publishedDate, publisherId, this.issn, this.itemId, this.language);
    }

    public Serial withIssn(ISSN issn) {
        return new Serial(this.title, Optional.ofNullable(this.abstract_), this.publishedDate, this.publisherId, issn, this.itemId, this.language);
    }

    public Serial withItemId(ItemId itemId) {
        return new Serial(this.title, Optional.ofNullable(this.abstract_), this.publishedDate, this.publisherId, this.issn, itemId, this.language);
    }

    public Serial withLanguage(Language language) {
        return new Serial(this.title, Optional.ofNullable(this.abstract_), this.publishedDate, this.publisherId, this.issn, this.itemId, language);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Serial other = (Serial)o;
        return Objects.equals(this.title, other.title) && Objects.equals(this.abstract_, other.abstract_) && Objects.equals(this.publishedDate, other.publishedDate) && Objects.equals(this.publisherId, other.publisherId) && Objects.equals(this.issn, other.issn) && Objects.equals(this.itemId, other.itemId) && Objects.equals((Object)this.language, (Object)other.language);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.abstract_, this.publishedDate, this.publisherId, this.issn, this.itemId, this.language});
    }

    public String toString() {
        return Util.toString(Serial.class, (Object[])new Object[]{"title", this.title, "abstract_", this.abstract_, "publishedDate", this.publishedDate, "publisherId", this.publisherId, "issn", this.issn, "itemId", this.itemId, "language", this.language});
    }

    public static final class BuilderWithLanguage {
        private final Builder b;

        BuilderWithLanguage(Builder b) {
            this.b = b;
        }

        public BuilderWithLanguage abstract_(Abstract abstract_) {
            this.b.abstract_ = Optional.of(abstract_);
            return this;
        }

        public BuilderWithLanguage abstract_(Optional<Abstract> abstract_) {
            this.b.abstract_ = abstract_;
            return this;
        }

        public Serial build() {
            return new Serial(this.b.title, this.b.abstract_, this.b.publishedDate, this.b.publisherId, this.b.issn, this.b.itemId, this.b.language);
        }
    }

    public static final class BuilderWithItemId {
        private final Builder b;

        BuilderWithItemId(Builder b) {
            this.b = b;
        }

        public BuilderWithLanguage language(Language language) {
            this.b.language = language;
            return new BuilderWithLanguage(this.b);
        }
    }

    public static final class BuilderWithIssn {
        private final Builder b;

        BuilderWithIssn(Builder b) {
            this.b = b;
        }

        public BuilderWithItemId itemId(ItemId itemId) {
            this.b.itemId = itemId;
            return new BuilderWithItemId(this.b);
        }
    }

    public static final class BuilderWithPublisherId {
        private final Builder b;

        BuilderWithPublisherId(Builder b) {
            this.b = b;
        }

        public BuilderWithIssn issn(ISSN issn) {
            this.b.issn = issn;
            return new BuilderWithIssn(this.b);
        }
    }

    public static final class BuilderWithPublishedDate {
        private final Builder b;

        BuilderWithPublishedDate(Builder b) {
            this.b = b;
        }

        public BuilderWithPublisherId publisherId(Id publisherId) {
            this.b.publisherId = publisherId;
            return new BuilderWithPublisherId(this.b);
        }
    }

    public static final class BuilderWithTitle {
        private final Builder b;

        BuilderWithTitle(Builder b) {
            this.b = b;
        }

        public BuilderWithPublishedDate publishedDate(LocalDate publishedDate) {
            this.b.publishedDate = publishedDate;
            return new BuilderWithPublishedDate(this.b);
        }
    }

    public static final class Builder {
        private String title;
        private LocalDate publishedDate;
        private Id publisherId;
        private ISSN issn;
        private ItemId itemId;
        private Language language;
        private Optional<Abstract> abstract_ = Optional.empty();

        Builder() {
        }

        public BuilderWithTitle title(String title) {
            this.title = title;
            return new BuilderWithTitle(this);
        }
    }
}

