/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class User {
    @JsonProperty(value="firstName")
    private final String firstName;
    @JsonProperty(value="lastName")
    private final String lastName;
    @JsonProperty(value="email")
    private final String email;
    @JsonProperty(value="mobile")
    private final String mobile;

    @JsonCreator
    private User(@JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="mobile") String mobile) {
        if (Globals.config().validateInConstructor().test(User.class)) {
            Preconditions.checkMinLength((String)firstName, (int)1, (String)"firstName");
            Preconditions.checkMinLength((String)lastName, (int)1, (String)"lastName");
            Preconditions.checkMinLength((String)email, (int)3, (String)"email");
            Preconditions.checkMatchesPattern((String)mobile, (String)"[\\+][0-9]+", (String)"mobile");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.mobile = mobile;
    }

    @ConstructorBinding
    public User(String firstName, String lastName, String email, Optional<String> mobile) {
        if (Globals.config().validateInConstructor().test(User.class)) {
            Preconditions.checkNotNull((Object)firstName, (String)"firstName");
            Preconditions.checkMinLength((String)firstName, (int)1, (String)"firstName");
            Preconditions.checkNotNull((Object)lastName, (String)"lastName");
            Preconditions.checkMinLength((String)lastName, (int)1, (String)"lastName");
            Preconditions.checkNotNull((Object)email, (String)"email");
            Preconditions.checkMinLength((String)email, (int)3, (String)"email");
            Preconditions.checkNotNull(mobile, (String)"mobile");
            Preconditions.checkMatchesPattern(mobile, (String)"[\\+][0-9]+", (String)"mobile");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.mobile = mobile.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String email() {
        return this.email;
    }

    public Optional<String> mobile() {
        return Optional.ofNullable(this.mobile);
    }

    public User withFirstName(String firstName) {
        return new User(firstName, this.lastName, this.email, Optional.ofNullable(this.mobile));
    }

    public User withLastName(String lastName) {
        return new User(this.firstName, lastName, this.email, Optional.ofNullable(this.mobile));
    }

    public User withEmail(String email) {
        return new User(this.firstName, this.lastName, email, Optional.ofNullable(this.mobile));
    }

    public User withMobile(Optional<String> mobile) {
        return new User(this.firstName, this.lastName, this.email, mobile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && Objects.equals(this.email, other.email) && Objects.equals(this.mobile, other.mobile);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.email, this.mobile);
    }

    public String toString() {
        return Util.toString(User.class, (Object[])new Object[]{"firstName", this.firstName, "lastName", this.lastName, "email", this.email, "mobile", this.mobile});
    }

    public static final class BuilderWithEmail {
        private final Builder b;

        BuilderWithEmail(Builder b) {
            this.b = b;
        }

        public BuilderWithEmail mobile(String mobile) {
            this.b.mobile = Optional.of(mobile);
            return this;
        }

        public BuilderWithEmail mobile(Optional<String> mobile) {
            this.b.mobile = mobile;
            return this;
        }

        public User build() {
            return new User(this.b.firstName, this.b.lastName, this.b.email, this.b.mobile);
        }
    }

    public static final class BuilderWithLastName {
        private final Builder b;

        BuilderWithLastName(Builder b) {
            this.b = b;
        }

        public BuilderWithEmail email(String email) {
            this.b.email = email;
            return new BuilderWithEmail(this.b);
        }
    }

    public static final class BuilderWithFirstName {
        private final Builder b;

        BuilderWithFirstName(Builder b) {
            this.b = b;
        }

        public BuilderWithLastName lastName(String lastName) {
            this.b.lastName = lastName;
            return new BuilderWithLastName(this.b);
        }
    }

    public static final class Builder {
        private String firstName;
        private String lastName;
        private String email;
        private Optional<String> mobile = Optional.empty();

        Builder() {
        }

        public BuilderWithFirstName firstName(String firstName) {
            this.firstName = firstName;
            return new BuilderWithFirstName(this);
        }
    }
}

