/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.ContinuationToken;
import org.davidmoten.oa3.codegen.test.library.schema.UserWithId;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class UsersPage {
    @JsonProperty(value="users")
    private final Users users;
    @JsonProperty(value="continuationToken")
    private final ContinuationToken continuationToken;

    @JsonCreator
    private UsersPage(@JsonProperty(value="users") Users users, @JsonProperty(value="continuationToken") ContinuationToken continuationToken) {
        this.users = users;
        this.continuationToken = continuationToken;
    }

    @ConstructorBinding
    public UsersPage(Users users, Optional<ContinuationToken> continuationToken) {
        if (Globals.config().validateInConstructor().test(UsersPage.class)) {
            Preconditions.checkNotNull((Object)users, (String)"users");
            Preconditions.checkNotNull(continuationToken, (String)"continuationToken");
        }
        this.users = users;
        this.continuationToken = continuationToken.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Users users() {
        return this.users;
    }

    public Optional<ContinuationToken> continuationToken() {
        return Optional.ofNullable(this.continuationToken);
    }

    public UsersPage withUsers(Users users) {
        return new UsersPage(users, Optional.ofNullable(this.continuationToken));
    }

    public UsersPage withContinuationToken(Optional<ContinuationToken> continuationToken) {
        return new UsersPage(this.users, continuationToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersPage other = (UsersPage)o;
        return Objects.equals(this.users, other.users) && Objects.equals(this.continuationToken, other.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.users, this.continuationToken);
    }

    public String toString() {
        return Util.toString(UsersPage.class, (Object[])new Object[]{"users", this.users, "continuationToken", this.continuationToken});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Users {
        @JsonValue
        private final List<UserWithId> value;

        @JsonCreator
        @ConstructorBinding
        public Users(List<UserWithId> value) {
            if (Globals.config().validateInConstructor().test(Users.class)) {
                Preconditions.checkNotNull(value, (String)"value");
            }
            this.value = value;
        }

        public static Users value(List<UserWithId> value) {
            return new Users(value);
        }

        public List<UserWithId> value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Users other = (Users)o;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return Util.toString(Users.class, (Object[])new Object[]{"value", this.value});
        }
    }

    public static final class BuilderWithUsers {
        private final Builder b;

        BuilderWithUsers(Builder b) {
            this.b = b;
        }

        public BuilderWithUsers continuationToken(ContinuationToken continuationToken) {
            this.b.continuationToken = Optional.of(continuationToken);
            return this;
        }

        public BuilderWithUsers continuationToken(Optional<ContinuationToken> continuationToken) {
            this.b.continuationToken = continuationToken;
            return this;
        }

        public UsersPage build() {
            return new UsersPage(this.b.users, this.b.continuationToken);
        }
    }

    public static final class Builder {
        private Users users;
        private Optional<ContinuationToken> continuationToken = Optional.empty();

        Builder() {
        }

        public BuilderWithUsers users(Users users) {
            this.users = users;
            return new BuilderWithUsers(this);
        }
    }
}

