/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Year {
    @JsonValue
    private final int value;

    @JsonCreator
    @ConstructorBinding
    public Year(int value) {
        if (Globals.config().validateInConstructor().test(Year.class)) {
            Preconditions.checkMinimum((Number)value, (String)"0", (String)"value", (boolean)false);
            Preconditions.checkMaximum((Number)value, (String)"2200", (String)"value", (boolean)false);
        }
        this.value = value;
    }

    public static Year value(int value) {
        return new Year(value);
    }

    public int value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Year other = (Year)o;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return Util.toString(Year.class, (Object[])new Object[]{"value", this.value});
    }
}

