/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.library.service;

import java.util.Optional;
import org.davidmoten.oa3.codegen.spring.runtime.ControllerExceptionHandler;
import org.davidmoten.oa3.codegen.spring.runtime.RequestPreconditions;
import org.davidmoten.oa3.codegen.test.library.Globals;
import org.davidmoten.oa3.codegen.test.library.schema.User;
import org.davidmoten.oa3.codegen.test.library.service.Service;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceController
implements ControllerExceptionHandler {
    private final Service service;

    public ServiceController(@Autowired(required=false) Service service) {
        this.service = (Service)Util.orElse((Object)service, (Object)new Service(){});
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/user"}, produces={"application/json"})
    public ResponseEntity<?> getUsers(@RequestParam(name="search", required=false) Optional<String> search, @RequestParam(name="continuationToken", required=false) Optional<String> continuationToken) {
        try {
            if (Globals.config().validateInControllerMethod().test("getUsers")) {
                RequestPreconditions.checkMinLength(search, (int)2, (String)"search");
            }
            if (Globals.config().validateInControllerMethod().test("getUsers")) {
                RequestPreconditions.checkMinLength(continuationToken, (int)1, (String)"continuationToken");
                RequestPreconditions.checkMaxLength(continuationToken, (int)1500, (String)"continuationToken");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getUsers(search, continuationToken));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/user"}, consumes={"application/json"})
    public ResponseEntity<?> createUser(@RequestBody User requestBody) {
        try {
            this.service.createUser(requestBody);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/user/{id}"}, produces={"application/json"})
    public ResponseEntity<?> getUser(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("getUser")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getUser(id));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/user/{id}"}, consumes={"application/json"})
    public ResponseEntity<?> updateUser(@PathVariable(name="id", required=true) String id, @RequestBody User requestBody) {
        try {
            if (Globals.config().validateInControllerMethod().test("updateUser")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            this.service.updateUser(id, requestBody);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/user/{id}"})
    public ResponseEntity<?> deleteUser(@PathVariable(name="id", required=true) String id) {
        try {
            if (Globals.config().validateInControllerMethod().test("deleteUser")) {
                RequestPreconditions.checkMinLength((String)id, (int)1, (String)"id");
            }
            this.service.deleteUser(id);
            return ResponseEntity.status((int)200).build();
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/item/{itemId}"}, produces={"application/json"})
    public ResponseEntity<?> getItem(@PathVariable(name="itemId", required=true) String itemId) {
        try {
            if (Globals.config().validateInControllerMethod().test("getItem")) {
                RequestPreconditions.checkMinLength((String)itemId, (int)1, (String)"itemId");
                RequestPreconditions.checkMaxLength((String)itemId, (int)255, (String)"itemId");
            }
            return ResponseEntity.status((int)200).body((Object)this.service.getItem(itemId));
        }
        catch (Throwable e) {
            return this.service.errorResponse(e);
        }
    }
}

