/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.client;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.davidmoten.oa3.codegen.client.runtime.ClientBuilder;
import org.davidmoten.oa3.codegen.http.Http;
import org.davidmoten.oa3.codegen.http.HttpMethod;
import org.davidmoten.oa3.codegen.http.HttpResponse;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.path.GetMsis200Response;
import org.davidmoten.oa3.codegen.test.main.schema.AuthenticationRequestBody;
import org.davidmoten.oa3.codegen.test.main.schema.AuthenticationResponse;
import org.davidmoten.oa3.codegen.test.main.schema.Error;
import org.davidmoten.oa3.codegen.test.main.schema.Msi;
import org.davidmoten.oa3.codegen.test.main.schema.MsiContent;
import org.davidmoten.oa3.codegen.test.main.schema.MsiId;
import org.davidmoten.oa3.codegen.test.main.schema.Status;

public class Client {
    private final Serializer serializer;
    private final List<Interceptor> interceptors;
    private final String basePath;

    private Client(Serializer serializer, List<Interceptor> interceptors, String basePath) {
        this.serializer = serializer;
        this.interceptors = interceptors;
        this.basePath = basePath;
    }

    public static ClientBuilder<Client> basePath(String basePath) {
        return new ClientBuilder(b -> new Client(b.serializer(), b.interceptors(), b.basePath()), Globals.config(), basePath);
    }

    public AuthenticationResponse getToken(AuthenticationRequestBody requestBody) {
        return (AuthenticationResponse)this.getTokenFullResponse(requestBody).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getTokenFullResponse(AuthenticationRequestBody requestBody) {
        return Http.method((HttpMethod)HttpMethod.POST).basePath(this.basePath).path("/authenticate").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().body((Object)requestBody).contentTypeApplicationJson().responseAs(AuthenticationResponse.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public GetMsis200Response getMsis(Optional<OffsetDateTime> startTimeMin, boolean startTimeMinInclusive, Optional<OffsetDateTime> startTimeMax, boolean startTimeMaxInclusive, Optional<OffsetDateTime> endTimeMin, Optional<Boolean> endTimeMinInclusive, Optional<OffsetDateTime> endTimeMax, boolean endTimeMaxInclusive, int limit, Optional<List<String>> status, Optional<String> broadcastType, Optional<String> continuationToken) {
        return (GetMsis200Response)this.getMsisFullResponse(startTimeMin, startTimeMinInclusive, startTimeMax, startTimeMaxInclusive, endTimeMin, endTimeMinInclusive, endTimeMax, endTimeMaxInclusive, limit, status, broadcastType, continuationToken).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getMsisFullResponse(Optional<OffsetDateTime> startTimeMin, boolean startTimeMinInclusive, Optional<OffsetDateTime> startTimeMax, boolean startTimeMaxInclusive, Optional<OffsetDateTime> endTimeMin, Optional<Boolean> endTimeMinInclusive, Optional<OffsetDateTime> endTimeMax, boolean endTimeMaxInclusive, int limit, Optional<List<String>> status, Optional<String> broadcastType, Optional<String> continuationToken) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/msi").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().queryParam("startTimeMin", startTimeMin).queryParam("startTimeMinInclusive", (Object)startTimeMinInclusive).queryParam("startTimeMax", startTimeMax).queryParam("startTimeMaxInclusive", (Object)startTimeMaxInclusive).queryParam("endTimeMin", endTimeMin).queryParam("endTimeMinInclusive", endTimeMinInclusive).queryParam("endTimeMax", endTimeMax).queryParam("endTimeMaxInclusive", (Object)endTimeMaxInclusive).queryParam("limit", (Object)limit).queryParam("status", status).queryParam("broadcastType", broadcastType).queryParam("continuationToken", continuationToken).responseAs(GetMsis200Response.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public MsiId createMsi(MsiContent requestBody) {
        return (MsiId)this.createMsiFullResponse(requestBody).assertStatusCodeMatches("201").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse createMsiFullResponse(MsiContent requestBody) {
        return Http.method((HttpMethod)HttpMethod.POST).basePath(this.basePath).path("/msi").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().body((Object)requestBody).contentTypeApplicationJson().responseAs(MsiId.class).whenStatusCodeMatches("201").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public Msi getMsi(String id) {
        return (Msi)this.getMsiFullResponse(id).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped();
    }

    public HttpResponse getMsiFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/msi/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).responseAs(Msi.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("404").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public HttpResponse sendMsiFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.PUT).basePath(this.basePath).path("/msi/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("404").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public HttpResponse cancelMsiFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.DELETE).basePath(this.basePath).path("/msi/{id}").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("404").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }

    public Status getMsiStatus(String id) {
        return (Status)((Object)this.getMsiStatusFullResponse(id).assertStatusCodeMatches("200").assertContentTypeMatches("application/json").dataUnwrapped());
    }

    public HttpResponse getMsiStatusFullResponse(String id) {
        return Http.method((HttpMethod)HttpMethod.GET).basePath(this.basePath).path("/msi/{id}/status").serializer(this.serializer).interceptors(this.interceptors).acceptApplicationJson().pathParam("id", (Object)id).responseAs(Status.class).whenStatusCodeMatches("200").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("400").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("401").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("403").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("404").whenContentTypeMatches("application/json").responseAs(Error.class).whenStatusCodeMatches("500").whenContentTypeMatches("application/json").call();
    }
}

