/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.ContinuationToken;
import org.davidmoten.oa3.codegen.test.main.schema.Msi;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class GetMsis200Response {
    @JsonProperty(value="msis")
    private final Msis msis;
    @JsonProperty(value="continuationToken")
    private final ContinuationToken continuationToken;

    @JsonCreator
    private GetMsis200Response(@JsonProperty(value="msis") Msis msis, @JsonProperty(value="continuationToken") ContinuationToken continuationToken) {
        this.msis = msis;
        this.continuationToken = continuationToken;
    }

    @ConstructorBinding
    public GetMsis200Response(Msis msis, Optional<ContinuationToken> continuationToken) {
        if (Globals.config().validateInConstructor().test(GetMsis200Response.class)) {
            Preconditions.checkNotNull((Object)msis, (String)"msis");
            Preconditions.checkNotNull(continuationToken, (String)"continuationToken");
        }
        this.msis = msis;
        this.continuationToken = continuationToken.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Msis msis() {
        return this.msis;
    }

    public Optional<ContinuationToken> continuationToken() {
        return Optional.ofNullable(this.continuationToken);
    }

    public GetMsis200Response withMsis(Msis msis) {
        return new GetMsis200Response(msis, Optional.ofNullable(this.continuationToken));
    }

    public GetMsis200Response withContinuationToken(Optional<ContinuationToken> continuationToken) {
        return new GetMsis200Response(this.msis, continuationToken);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetMsis200Response other = (GetMsis200Response)o;
        return Objects.equals(this.msis, other.msis) && Objects.equals(this.continuationToken, other.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.msis, this.continuationToken);
    }

    public String toString() {
        return Util.toString(GetMsis200Response.class, (Object[])new Object[]{"msis", this.msis, "continuationToken", this.continuationToken});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Msis {
        @JsonValue
        private final List<Msi> value;

        @JsonCreator
        @ConstructorBinding
        public Msis(List<Msi> value) {
            if (Globals.config().validateInConstructor().test(Msis.class)) {
                Preconditions.checkNotNull(value, (String)"value");
            }
            this.value = value;
        }

        public static Msis value(List<Msi> value) {
            return new Msis(value);
        }

        public List<Msi> value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Msis other = (Msis)o;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return Util.toString(Msis.class, (Object[])new Object[]{"value", this.value});
        }
    }

    public static final class BuilderWithMsis {
        private final Builder b;

        BuilderWithMsis(Builder b) {
            this.b = b;
        }

        public BuilderWithMsis continuationToken(ContinuationToken continuationToken) {
            this.b.continuationToken = Optional.of(continuationToken);
            return this;
        }

        public BuilderWithMsis continuationToken(Optional<ContinuationToken> continuationToken) {
            this.b.continuationToken = continuationToken;
            return this;
        }

        public GetMsis200Response build() {
            return new GetMsis200Response(this.b.msis, this.b.continuationToken);
        }
    }

    public static final class Builder {
        private Msis msis;
        private Optional<ContinuationToken> continuationToken = Optional.empty();

        Builder() {
        }

        public BuilderWithMsis msis(Msis msis) {
            this.msis = msis;
            return new BuilderWithMsis(this);
        }
    }
}

