/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.MapBuilder;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class AdditionalProperties {
    @JsonAnyGetter
    @JsonAnySetter
    private final Map<String, Long> properties;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="age")
    private final Integer age;

    @JsonCreator
    private AdditionalProperties(@JsonProperty(value="name") String name, @JsonProperty(value="age") Integer age) {
        this.properties = new HashMap<String, Long>();
        this.name = name;
        this.age = age;
    }

    @ConstructorBinding
    public AdditionalProperties(Map<String, Long> properties, Optional<String> name, Optional<Integer> age) {
        if (Globals.config().validateInConstructor().test(AdditionalProperties.class)) {
            Preconditions.checkNotNull(name, (String)"name");
            Preconditions.checkNotNull(age, (String)"age");
        }
        this.properties = properties;
        this.name = name.orElse(null);
        this.age = age.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonAnySetter
    private void put(String key, Long value) {
        this.properties.put(key, value);
    }

    public Map<String, Long> properties() {
        return this.properties;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Integer> age() {
        return Optional.ofNullable(this.age);
    }

    public AdditionalProperties withProperties(Map<String, Long> properties) {
        return new AdditionalProperties(properties, Optional.ofNullable(this.name), Optional.ofNullable(this.age));
    }

    public AdditionalProperties withName(Optional<String> name) {
        return new AdditionalProperties(this.properties, name, Optional.ofNullable(this.age));
    }

    public AdditionalProperties withAge(Optional<Integer> age) {
        return new AdditionalProperties(this.properties, Optional.ofNullable(this.name), age);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalProperties other = (AdditionalProperties)o;
        return Objects.equals(this.properties, other.properties) && Objects.equals(this.name, other.name) && Objects.equals(this.age, other.age);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.name, this.age);
    }

    public String toString() {
        return Util.toString(AdditionalProperties.class, (Object[])new Object[]{"properties", this.properties, "name", this.name, "age", this.age});
    }

    public static final class Builder {
        private Map<String, Long> properties = new HashMap<String, Long>();
        private Optional<String> name = Optional.empty();
        private Optional<Integer> age = Optional.empty();

        Builder() {
        }

        public MapBuilder<Long, Builder> addToProperties(String key, Long value) {
            Preconditions.checkNotNull((Object)value, (String)"value");
            return new MapBuilder((Object)this, x -> {
                this.properties = x;
            }).add(key, (Object)value);
        }

        public MapBuilder<Long, Builder> addAllToProperties(Map<String, Long> map) {
            return new MapBuilder((Object)this, x -> {
                this.properties = x;
            }).addAll(map);
        }

        public Builder properties(Map<String, Long> properties) {
            this.properties = properties;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder age(int age) {
            this.age = Optional.of(age);
            return this;
        }

        public Builder age(Optional<Integer> age) {
            this.age = age;
            return this;
        }

        public AdditionalProperties build() {
            return new AdditionalProperties(this.properties, this.name, this.age);
        }
    }
}

