/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class ArrayComplex {
    @JsonValue
    private final List<ArrayComplexItem> value;

    @JsonCreator
    @ConstructorBinding
    public ArrayComplex(List<ArrayComplexItem> value) {
        if (Globals.config().validateInConstructor().test(ArrayComplex.class)) {
            Preconditions.checkNotNull(value, (String)"value");
        }
        this.value = value;
    }

    public static ArrayComplex value(List<ArrayComplexItem> value) {
        return new ArrayComplex(value);
    }

    public List<ArrayComplexItem> value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayComplex other = (ArrayComplex)o;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return Util.toString(ArrayComplex.class, (Object[])new Object[]{"value", this.value});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class ArrayComplexItem {
        @JsonProperty(value="firstName")
        private final String firstName;
        @JsonProperty(value="secondName")
        private final String secondName;

        @JsonCreator
        private ArrayComplexItem(@JsonProperty(value="firstName") String firstName, @JsonProperty(value="secondName") String secondName) {
            this.firstName = firstName;
            this.secondName = secondName;
        }

        @ConstructorBinding
        public ArrayComplexItem(String firstName, Optional<String> secondName) {
            if (Globals.config().validateInConstructor().test(ArrayComplexItem.class)) {
                Preconditions.checkNotNull((Object)firstName, (String)"firstName");
                Preconditions.checkNotNull(secondName, (String)"secondName");
            }
            this.firstName = firstName;
            this.secondName = secondName.orElse(null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String firstName() {
            return this.firstName;
        }

        public Optional<String> secondName() {
            return Optional.ofNullable(this.secondName);
        }

        public ArrayComplexItem withFirstName(String firstName) {
            return new ArrayComplexItem(firstName, Optional.ofNullable(this.secondName));
        }

        public ArrayComplexItem withSecondName(Optional<String> secondName) {
            return new ArrayComplexItem(this.firstName, secondName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayComplexItem other = (ArrayComplexItem)o;
            return Objects.equals(this.firstName, other.firstName) && Objects.equals(this.secondName, other.secondName);
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.secondName);
        }

        public String toString() {
            return Util.toString(ArrayComplexItem.class, (Object[])new Object[]{"firstName", this.firstName, "secondName", this.secondName});
        }

        public static final class BuilderWithFirstName {
            private final Builder b;

            BuilderWithFirstName(Builder b) {
                this.b = b;
            }

            public BuilderWithFirstName secondName(String secondName) {
                this.b.secondName = Optional.of(secondName);
                return this;
            }

            public BuilderWithFirstName secondName(Optional<String> secondName) {
                this.b.secondName = secondName;
                return this;
            }

            public ArrayComplexItem build() {
                return new ArrayComplexItem(this.b.firstName, this.b.secondName);
            }
        }

        public static final class Builder {
            private String firstName;
            private Optional<String> secondName = Optional.empty();

            Builder() {
            }

            public BuilderWithFirstName firstName(String firstName) {
                this.firstName = firstName;
                return new BuilderWithFirstName(this);
            }
        }
    }
}

