/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class AuthenticationRequestBody {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="validityMinutes")
    private final Integer validityMinutes;

    @JsonCreator
    private AuthenticationRequestBody(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="validityMinutes") Integer validityMinutes) {
        if (Globals.config().validateInConstructor().test(AuthenticationRequestBody.class)) {
            Preconditions.checkMinLength((String)username, (int)1, (String)"username");
            Preconditions.checkMinLength((String)password, (int)1, (String)"password");
            Preconditions.checkMinimum((Number)validityMinutes, (String)"1", (String)"validityMinutes", (boolean)false);
        }
        this.username = username;
        this.password = password;
        this.validityMinutes = validityMinutes;
    }

    @ConstructorBinding
    public AuthenticationRequestBody(String username, String password, Optional<Integer> validityMinutes) {
        if (Globals.config().validateInConstructor().test(AuthenticationRequestBody.class)) {
            Preconditions.checkNotNull((Object)username, (String)"username");
            Preconditions.checkMinLength((String)username, (int)1, (String)"username");
            Preconditions.checkNotNull((Object)password, (String)"password");
            Preconditions.checkMinLength((String)password, (int)1, (String)"password");
            Preconditions.checkNotNull(validityMinutes, (String)"validityMinutes");
            Preconditions.checkMinimum(validityMinutes, (String)"1", (String)"validityMinutes", (boolean)false);
        }
        this.username = username;
        this.password = password;
        this.validityMinutes = validityMinutes.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public Optional<Integer> validityMinutes() {
        return Optional.ofNullable(this.validityMinutes);
    }

    public AuthenticationRequestBody withUsername(String username) {
        return new AuthenticationRequestBody(username, this.password, Optional.ofNullable(this.validityMinutes));
    }

    public AuthenticationRequestBody withPassword(String password) {
        return new AuthenticationRequestBody(this.username, password, Optional.ofNullable(this.validityMinutes));
    }

    public AuthenticationRequestBody withValidityMinutes(Optional<Integer> validityMinutes) {
        return new AuthenticationRequestBody(this.username, this.password, validityMinutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationRequestBody other = (AuthenticationRequestBody)o;
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.validityMinutes, other.validityMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.validityMinutes);
    }

    public String toString() {
        return Util.toString(AuthenticationRequestBody.class, (Object[])new Object[]{"username", this.username, "password", this.password, "validityMinutes", this.validityMinutes});
    }

    public static final class BuilderWithPassword {
        private final Builder b;

        BuilderWithPassword(Builder b) {
            this.b = b;
        }

        public BuilderWithPassword validityMinutes(int validityMinutes) {
            this.b.validityMinutes = Optional.of(validityMinutes);
            return this;
        }

        public BuilderWithPassword validityMinutes(Optional<Integer> validityMinutes) {
            this.b.validityMinutes = validityMinutes;
            return this;
        }

        public AuthenticationRequestBody build() {
            return new AuthenticationRequestBody(this.b.username, this.b.password, this.b.validityMinutes);
        }
    }

    public static final class BuilderWithUsername {
        private final Builder b;

        BuilderWithUsername(Builder b) {
            this.b = b;
        }

        public BuilderWithPassword password(String password) {
            this.b.password = password;
            return new BuilderWithPassword(this.b);
        }
    }

    public static final class Builder {
        private String username;
        private String password;
        private Optional<Integer> validityMinutes = Optional.empty();

        Builder() {
        }

        public BuilderWithUsername username(String username) {
            this.username = username;
            return new BuilderWithUsername(this);
        }
    }
}

