/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class AuthenticationResponse {
    @JsonProperty(value="token")
    private final String token;
    @JsonProperty(value="expiryTime")
    private final OffsetDateTime expiryTime;

    @JsonCreator
    @ConstructorBinding
    public AuthenticationResponse(@JsonProperty(value="token") String token, @JsonProperty(value="expiryTime") OffsetDateTime expiryTime) {
        if (Globals.config().validateInConstructor().test(AuthenticationResponse.class)) {
            Preconditions.checkNotNull((Object)token, (String)"token");
            Preconditions.checkMinLength((String)token, (int)1, (String)"token");
            Preconditions.checkNotNull((Object)expiryTime, (String)"expiryTime");
        }
        this.token = token;
        this.expiryTime = expiryTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String token() {
        return this.token;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public AuthenticationResponse withToken(String token) {
        return new AuthenticationResponse(token, this.expiryTime);
    }

    public AuthenticationResponse withExpiryTime(OffsetDateTime expiryTime) {
        return new AuthenticationResponse(this.token, expiryTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationResponse other = (AuthenticationResponse)o;
        return Objects.equals(this.token, other.token) && Objects.equals(this.expiryTime, other.expiryTime);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.expiryTime);
    }

    public String toString() {
        return Util.toString(AuthenticationResponse.class, (Object[])new Object[]{"token", this.token, "expiryTime", this.expiryTime});
    }

    public static final class BuilderWithExpiryTime {
        private final Builder b;

        BuilderWithExpiryTime(Builder b) {
            this.b = b;
        }

        public AuthenticationResponse build() {
            return new AuthenticationResponse(this.b.token, this.b.expiryTime);
        }
    }

    public static final class BuilderWithToken {
        private final Builder b;

        BuilderWithToken(Builder b) {
            this.b = b;
        }

        public BuilderWithExpiryTime expiryTime(OffsetDateTime expiryTime) {
            this.b.expiryTime = expiryTime;
            return new BuilderWithExpiryTime(this.b);
        }
    }

    public static final class Builder {
        private String token;
        private OffsetDateTime expiryTime;

        Builder() {
        }

        public BuilderWithToken token(String token) {
            this.token = token;
            return new BuilderWithToken(this);
        }
    }
}

