/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.DiscriminatorHelper;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.HasWheels;
import org.davidmoten.oa3.codegen.test.main.schema.Vehicle;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Bike
implements Vehicle,
HasWheels {
    @JsonProperty(value="vehicleType")
    private final String vehicleType;
    @JsonProperty(value="wheelsType")
    private final String wheelsType;
    @JsonProperty(value="colour")
    private final String colour;

    @JsonCreator
    private Bike(@JsonProperty(value="vehicleType") String vehicleType, @JsonProperty(value="wheelsType") String wheelsType, @JsonProperty(value="colour") String colour) {
        this.vehicleType = vehicleType;
        this.wheelsType = wheelsType;
        this.colour = colour;
    }

    @ConstructorBinding
    public Bike(String colour) {
        if (Globals.config().validateInConstructor().test(Bike.class)) {
            Preconditions.checkNotNull((Object)colour, (String)"colour");
        }
        this.vehicleType = (String)DiscriminatorHelper.value(String.class, (String)"bike");
        this.wheelsType = (String)DiscriminatorHelper.value(String.class, (String)"two");
        this.colour = colour;
    }

    public static Bike colour(String colour) {
        return new Bike(colour);
    }

    @Override
    public String vehicleType() {
        return (String)DiscriminatorHelper.value((Object)this.vehicleType);
    }

    @Override
    public String wheelsType() {
        return (String)DiscriminatorHelper.value((Object)this.wheelsType);
    }

    public String colour() {
        return this.colour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bike other = (Bike)o;
        return Objects.equals(this.vehicleType, other.vehicleType) && Objects.equals(this.wheelsType, other.wheelsType) && Objects.equals(this.colour, other.colour);
    }

    public int hashCode() {
        return Objects.hash(this.vehicleType, this.wheelsType, this.colour);
    }

    public String toString() {
        return Util.toString(Bike.class, (Object[])new Object[]{"vehicleType", this.vehicleType, "wheelsType", this.wheelsType, "colour", this.colour});
    }
}

