/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.DogBreed;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Breeding {
    @JsonProperty(value="breeder")
    private final String breeder;
    @JsonProperty(value="breed")
    private final DogBreed breed;

    @JsonCreator
    @ConstructorBinding
    public Breeding(@JsonProperty(value="breeder") String breeder, @JsonProperty(value="breed") DogBreed breed) {
        if (Globals.config().validateInConstructor().test(Breeding.class)) {
            Preconditions.checkNotNull((Object)breeder, (String)"breeder");
            Preconditions.checkNotNull((Object)((Object)breed), (String)"breed");
        }
        this.breeder = breeder;
        this.breed = breed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String breeder() {
        return this.breeder;
    }

    public DogBreed breed() {
        return this.breed;
    }

    public Breeding withBreeder(String breeder) {
        return new Breeding(breeder, this.breed);
    }

    public Breeding withBreed(DogBreed breed) {
        return new Breeding(this.breeder, breed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breeding other = (Breeding)o;
        return Objects.equals(this.breeder, other.breeder) && Objects.equals((Object)this.breed, (Object)other.breed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.breeder, this.breed});
    }

    public String toString() {
        return Util.toString(Breeding.class, (Object[])new Object[]{"breeder", this.breeder, "breed", this.breed});
    }

    public static final class BuilderWithBreed {
        private final Builder b;

        BuilderWithBreed(Builder b) {
            this.b = b;
        }

        public Breeding build() {
            return new Breeding(this.b.breeder, this.b.breed);
        }
    }

    public static final class BuilderWithBreeder {
        private final Builder b;

        BuilderWithBreeder(Builder b) {
            this.b = b;
        }

        public BuilderWithBreed breed(DogBreed breed) {
            this.b.breed = breed;
            return new BuilderWithBreed(this.b);
        }
    }

    public static final class Builder {
        private String breeder;
        private DogBreed breed;

        Builder() {
        }

        public BuilderWithBreeder breeder(String breeder) {
            this.breeder = breeder;
            return new BuilderWithBreeder(this);
        }
    }
}

