/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Latitude;
import org.davidmoten.oa3.codegen.test.main.schema.Longitude;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Circle {
    @JsonProperty(value="lat")
    private final Latitude lat;
    @JsonProperty(value="lon")
    private final Longitude lon;
    @JsonProperty(value="radiusNm")
    private final float radiusNm;

    @JsonCreator
    @ConstructorBinding
    public Circle(@JsonProperty(value="lat") Latitude lat, @JsonProperty(value="lon") Longitude lon, @JsonProperty(value="radiusNm") float radiusNm) {
        if (Globals.config().validateInConstructor().test(Circle.class)) {
            Preconditions.checkNotNull((Object)lat, (String)"lat");
            Preconditions.checkNotNull((Object)lon, (String)"lon");
            Preconditions.checkMinimum((Number)Float.valueOf(radiusNm), (String)"0", (String)"radiusNm", (boolean)false);
        }
        this.lat = lat;
        this.lon = lon;
        this.radiusNm = radiusNm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Latitude lat() {
        return this.lat;
    }

    public Longitude lon() {
        return this.lon;
    }

    public float radiusNm() {
        return this.radiusNm;
    }

    public Circle withLat(Latitude lat) {
        return new Circle(lat, this.lon, this.radiusNm);
    }

    public Circle withLon(Longitude lon) {
        return new Circle(this.lat, lon, this.radiusNm);
    }

    public Circle withRadiusNm(float radiusNm) {
        return new Circle(this.lat, this.lon, radiusNm);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle other = (Circle)o;
        return Objects.equals(this.lat, other.lat) && Objects.equals(this.lon, other.lon) && Objects.equals(Float.valueOf(this.radiusNm), Float.valueOf(other.radiusNm));
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon, Float.valueOf(this.radiusNm));
    }

    public String toString() {
        return Util.toString(Circle.class, (Object[])new Object[]{"lat", this.lat, "lon", this.lon, "radiusNm", Float.valueOf(this.radiusNm)});
    }

    public static final class BuilderWithRadiusNm {
        private final Builder b;

        BuilderWithRadiusNm(Builder b) {
            this.b = b;
        }

        public Circle build() {
            return new Circle(this.b.lat, this.b.lon, this.b.radiusNm);
        }
    }

    public static final class BuilderWithLon {
        private final Builder b;

        BuilderWithLon(Builder b) {
            this.b = b;
        }

        public BuilderWithRadiusNm radiusNm(float radiusNm) {
            this.b.radiusNm = radiusNm;
            return new BuilderWithRadiusNm(this.b);
        }
    }

    public static final class BuilderWithLat {
        private final Builder b;

        BuilderWithLat(Builder b) {
            this.b = b;
        }

        public BuilderWithLon lon(Longitude lon) {
            this.b.lon = lon;
            return new BuilderWithLon(this.b);
        }
    }

    public static final class Builder {
        private Latitude lat;
        private Longitude lon;
        private float radiusNm;

        Builder() {
        }

        public BuilderWithLat lat(Latitude lat) {
            this.lat = lat;
            return new BuilderWithLat(this);
        }
    }
}

