/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.PolymorphicDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Pet;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonDeserialize(using=Deserializer.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Dog {
    @JsonUnwrapped
    private final Pet pet;
    @JsonUnwrapped
    private final Object1 object1;

    public Dog(Pet pet, Object1 object1) {
        if (Globals.config().validateInConstructor().test(Dog.class)) {
            Preconditions.checkNotNull((Object)pet, (String)"pet");
            Preconditions.checkNotNull((Object)object1, (String)"object1");
        }
        this.pet = pet;
        this.object1 = object1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Pet pet() {
        return this.pet;
    }

    public Object1 object1() {
        return this.object1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dog other = (Dog)o;
        return Objects.equals(this.pet, other.pet) && Objects.equals(this.object1, other.object1);
    }

    public int hashCode() {
        return Objects.hash(this.pet, this.object1);
    }

    public String toString() {
        return Util.toString(Dog.class, (Object[])new Object[]{"pet", this.pet, "object1", this.object1});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Object1 {
        @JsonProperty(value="breed")
        private final Breed breed;

        @JsonCreator
        private Object1(@JsonProperty(value="breed") Breed breed) {
            this.breed = breed;
        }

        @ConstructorBinding
        public Object1(Optional<Breed> breed) {
            if (Globals.config().validateInConstructor().test(Object1.class)) {
                Preconditions.checkNotNull(breed, (String)"breed");
            }
            this.breed = breed.orElse(null);
        }

        public static Object1 breed(Optional<Breed> breed) {
            return new Object1(breed);
        }

        public static Object1 breed(Breed breed) {
            return new Object1(Optional.of(breed));
        }

        public Optional<Breed> breed() {
            return Optional.ofNullable(this.breed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Object1 other = (Object1)o;
            return Objects.equals((Object)this.breed, (Object)other.breed);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.breed});
        }

        public String toString() {
            return Util.toString(Object1.class, (Object[])new Object[]{"breed", this.breed});
        }

        public static enum Breed {
            POODLE("poodle"),
            CROSS("cross");

            @JsonValue
            private final String value;

            private Breed(String value) {
                this.value = value;
            }

            public String value() {
                return this.value;
            }

            @JsonCreator
            public static Breed fromValue(Object value) {
                for (Breed x : Breed.values()) {
                    if (!Objects.equals(value, x.value)) continue;
                    return x;
                }
                throw new IllegalArgumentException("unexpected enum value: '" + value + "'");
            }
        }
    }

    public static final class Deserializer
    extends PolymorphicDeserializer<Dog> {
        public Deserializer() {
            super(Globals.config(), PolymorphicType.ALL_OF, Dog.class, new Class[]{Pet.class, Object1.class});
        }
    }

    public static final class BuilderWithObject1 {
        private final Builder b;

        BuilderWithObject1(Builder b) {
            this.b = b;
        }

        public Dog build() {
            return new Dog(this.b.pet, this.b.object1);
        }
    }

    public static final class BuilderWithPet {
        private final Builder b;

        BuilderWithPet(Builder b) {
            this.b = b;
        }

        public BuilderWithObject1 object1(Object1 object1) {
            this.b.object1 = object1;
            return new BuilderWithObject1(this.b);
        }
    }

    public static final class Builder {
        private Pet pet;
        private Object1 object1;

        Builder() {
        }

        public BuilderWithPet pet(Pet pet) {
            this.pet = pet;
            return new BuilderWithPet(this);
        }
    }
}

