/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.PolymorphicDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Breeding;
import org.davidmoten.oa3.codegen.test.main.schema.Pet;
import org.davidmoten.oa3.codegen.util.Util;

@JsonDeserialize(using=Deserializer.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Dog2 {
    @JsonUnwrapped
    private final Pet pet;
    @JsonUnwrapped
    private final Breeding breeding;

    public Dog2(Pet pet, Breeding breeding) {
        if (Globals.config().validateInConstructor().test(Dog2.class)) {
            Preconditions.checkNotNull((Object)pet, (String)"pet");
            Preconditions.checkNotNull((Object)breeding, (String)"breeding");
        }
        this.pet = pet;
        this.breeding = breeding;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Pet pet() {
        return this.pet;
    }

    public Breeding breeding() {
        return this.breeding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dog2 other = (Dog2)o;
        return Objects.equals(this.pet, other.pet) && Objects.equals(this.breeding, other.breeding);
    }

    public int hashCode() {
        return Objects.hash(this.pet, this.breeding);
    }

    public String toString() {
        return Util.toString(Dog2.class, (Object[])new Object[]{"pet", this.pet, "breeding", this.breeding});
    }

    public static final class Deserializer
    extends PolymorphicDeserializer<Dog2> {
        public Deserializer() {
            super(Globals.config(), PolymorphicType.ALL_OF, Dog2.class, new Class[]{Pet.class, Breeding.class});
        }
    }

    public static final class BuilderWithBreeding {
        private final Builder b;

        BuilderWithBreeding(Builder b) {
            this.b = b;
        }

        public Dog2 build() {
            return new Dog2(this.b.pet, this.b.breeding);
        }
    }

    public static final class BuilderWithPet {
        private final Builder b;

        BuilderWithPet(Builder b) {
            this.b = b;
        }

        public BuilderWithBreeding breeding(Breeding breeding) {
            this.b.breeding = breeding;
            return new BuilderWithBreeding(this.b);
        }
    }

    public static final class Builder {
        private Pet pet;
        private Breeding breeding;

        Builder() {
        }

        public BuilderWithPet pet(Pet pet) {
            this.pet = pet;
            return new BuilderWithPet(this);
        }
    }
}

