/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Error {
    @JsonProperty(value="statusCode")
    private final Integer statusCode;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="errorType")
    private final String errorType;
    @JsonProperty(value="stackTrace")
    private final StackTrace stackTrace;
    @JsonProperty(value="cause")
    private final Error cause;

    @JsonCreator
    private Error(@JsonProperty(value="statusCode") Integer statusCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorType") String errorType, @JsonProperty(value="stackTrace") StackTrace stackTrace, @JsonProperty(value="cause") Error cause) {
        if (Globals.config().validateInConstructor().test(Error.class)) {
            Preconditions.checkMinimum((Number)statusCode, (String)"100", (String)"statusCode", (boolean)false);
            Preconditions.checkMaximum((Number)statusCode, (String)"599", (String)"statusCode", (boolean)false);
        }
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
        this.errorType = errorType;
        this.stackTrace = stackTrace;
        this.cause = cause;
    }

    @ConstructorBinding
    public Error(Optional<Integer> statusCode, Optional<String> errorMessage, Optional<String> errorType, Optional<StackTrace> stackTrace, Optional<Error> cause) {
        if (Globals.config().validateInConstructor().test(Error.class)) {
            Preconditions.checkNotNull(statusCode, (String)"statusCode");
            Preconditions.checkMinimum(statusCode, (String)"100", (String)"statusCode", (boolean)false);
            Preconditions.checkMaximum(statusCode, (String)"599", (String)"statusCode", (boolean)false);
            Preconditions.checkNotNull(errorMessage, (String)"errorMessage");
            Preconditions.checkNotNull(errorType, (String)"errorType");
            Preconditions.checkNotNull(stackTrace, (String)"stackTrace");
            Preconditions.checkNotNull(cause, (String)"cause");
        }
        this.statusCode = statusCode.orElse(null);
        this.errorMessage = errorMessage.orElse(null);
        this.errorType = errorType.orElse(null);
        this.stackTrace = stackTrace.orElse(null);
        this.cause = cause.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Integer> statusCode() {
        return Optional.ofNullable(this.statusCode);
    }

    public Optional<String> errorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public Optional<String> errorType() {
        return Optional.ofNullable(this.errorType);
    }

    public Optional<StackTrace> stackTrace() {
        return Optional.ofNullable(this.stackTrace);
    }

    public Optional<Error> cause() {
        return Optional.ofNullable(this.cause);
    }

    public Error withStatusCode(Optional<Integer> statusCode) {
        return new Error(statusCode, Optional.ofNullable(this.errorMessage), Optional.ofNullable(this.errorType), Optional.ofNullable(this.stackTrace), Optional.ofNullable(this.cause));
    }

    public Error withErrorMessage(Optional<String> errorMessage) {
        return new Error(Optional.ofNullable(this.statusCode), errorMessage, Optional.ofNullable(this.errorType), Optional.ofNullable(this.stackTrace), Optional.ofNullable(this.cause));
    }

    public Error withErrorType(Optional<String> errorType) {
        return new Error(Optional.ofNullable(this.statusCode), Optional.ofNullable(this.errorMessage), errorType, Optional.ofNullable(this.stackTrace), Optional.ofNullable(this.cause));
    }

    public Error withStackTrace(Optional<StackTrace> stackTrace) {
        return new Error(Optional.ofNullable(this.statusCode), Optional.ofNullable(this.errorMessage), Optional.ofNullable(this.errorType), stackTrace, Optional.ofNullable(this.cause));
    }

    public Error withCause(Optional<Error> cause) {
        return new Error(Optional.ofNullable(this.statusCode), Optional.ofNullable(this.errorMessage), Optional.ofNullable(this.errorType), Optional.ofNullable(this.stackTrace), cause);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error other = (Error)o;
        return Objects.equals(this.statusCode, other.statusCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.errorType, other.errorType) && Objects.equals(this.stackTrace, other.stackTrace) && Objects.equals(this.cause, other.cause);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.errorMessage, this.errorType, this.stackTrace, this.cause);
    }

    public String toString() {
        return Util.toString(Error.class, (Object[])new Object[]{"statusCode", this.statusCode, "errorMessage", this.errorMessage, "errorType", this.errorType, "stackTrace", this.stackTrace, "cause", this.cause});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class StackTrace {
        @JsonValue
        private final List<String> value;

        @JsonCreator
        @ConstructorBinding
        public StackTrace(List<String> value) {
            if (Globals.config().validateInConstructor().test(StackTrace.class)) {
                Preconditions.checkNotNull(value, (String)"value");
            }
            this.value = value;
        }

        public static StackTrace value(List<String> value) {
            return new StackTrace(value);
        }

        public List<String> value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackTrace other = (StackTrace)o;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return Util.toString(StackTrace.class, (Object[])new Object[]{"value", this.value});
        }
    }

    public static final class Builder {
        private Optional<Integer> statusCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Optional<String> errorType = Optional.empty();
        private Optional<StackTrace> stackTrace = Optional.empty();
        private Optional<Error> cause = Optional.empty();

        Builder() {
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = Optional.of(statusCode);
            return this;
        }

        public Builder statusCode(Optional<Integer> statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = Optional.of(errorMessage);
            return this;
        }

        public Builder errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder errorType(String errorType) {
            this.errorType = Optional.of(errorType);
            return this;
        }

        public Builder errorType(Optional<String> errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder stackTrace(StackTrace stackTrace) {
            this.stackTrace = Optional.of(stackTrace);
            return this;
        }

        public Builder stackTrace(Optional<StackTrace> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder cause(Error cause) {
            this.cause = Optional.of(cause);
            return this;
        }

        public Builder cause(Optional<Error> cause) {
            this.cause = cause;
            return this;
        }

        public Error build() {
            return new Error(this.statusCode, this.errorMessage, this.errorType, this.stackTrace, this.cause);
        }
    }
}

