/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Longitude {
    @JsonValue
    private final float value;

    @JsonCreator
    @ConstructorBinding
    public Longitude(float value) {
        if (Globals.config().validateInConstructor().test(Longitude.class)) {
            Preconditions.checkMinimum((Number)Float.valueOf(value), (String)"-180", (String)"value", (boolean)false);
            Preconditions.checkMaximum((Number)Float.valueOf(value), (String)"180", (String)"value", (boolean)false);
        }
        this.value = value;
    }

    public static Longitude value(float value) {
        return new Longitude(value);
    }

    public float value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Longitude other = (Longitude)o;
        return Objects.equals(Float.valueOf(this.value), Float.valueOf(other.value));
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.value));
    }

    public String toString() {
        return Util.toString(Longitude.class, (Object[])new Object[]{"value", Float.valueOf(this.value)});
    }
}

