/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.MetBroadcastArea;
import org.davidmoten.oa3.codegen.test.main.schema.NonSARPriority;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class MetBroadcast {
    @JsonProperty(value="area")
    private final MetBroadcastArea area;
    @JsonProperty(value="priority")
    private final NonSARPriority priority;

    @JsonCreator
    @ConstructorBinding
    public MetBroadcast(@JsonProperty(value="area") MetBroadcastArea area, @JsonProperty(value="priority") NonSARPriority priority) {
        if (Globals.config().validateInConstructor().test(MetBroadcast.class)) {
            Preconditions.checkNotNull((Object)area, (String)"area");
            Preconditions.checkNotNull((Object)((Object)priority), (String)"priority");
        }
        this.area = area;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MetBroadcastArea area() {
        return this.area;
    }

    public NonSARPriority priority() {
        return this.priority;
    }

    public MetBroadcast withArea(MetBroadcastArea area) {
        return new MetBroadcast(area, this.priority);
    }

    public MetBroadcast withPriority(NonSARPriority priority) {
        return new MetBroadcast(this.area, priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetBroadcast other = (MetBroadcast)o;
        return Objects.equals(this.area, other.area) && Objects.equals((Object)this.priority, (Object)other.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.area, this.priority});
    }

    public String toString() {
        return Util.toString(MetBroadcast.class, (Object[])new Object[]{"area", this.area, "priority", this.priority});
    }

    public static final class BuilderWithPriority {
        private final Builder b;

        BuilderWithPriority(Builder b) {
            this.b = b;
        }

        public MetBroadcast build() {
            return new MetBroadcast(this.b.area, this.b.priority);
        }
    }

    public static final class BuilderWithArea {
        private final Builder b;

        BuilderWithArea(Builder b) {
            this.b = b;
        }

        public BuilderWithPriority priority(NonSARPriority priority) {
            this.b.priority = priority;
            return new BuilderWithPriority(this.b);
        }
    }

    public static final class Builder {
        private MetBroadcastArea area;
        private NonSARPriority priority;

        Builder() {
        }

        public BuilderWithArea area(MetBroadcastArea area) {
            this.area = area;
            return new BuilderWithArea(this);
        }
    }
}

