/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.MetAreaCode;
import org.davidmoten.oa3.codegen.test.main.schema.SubjectIndicator;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class MetCoastalWarningArea {
    @JsonProperty(value="subjectIndicator")
    private final SubjectIndicator subjectIndicator;
    @JsonProperty(value="metAreaCode")
    private final MetAreaCode metAreaCode;
    @JsonProperty(value="coastalWarningAreaCode")
    private final String coastalWarningAreaCode;

    @JsonCreator
    @ConstructorBinding
    public MetCoastalWarningArea(@JsonProperty(value="subjectIndicator") SubjectIndicator subjectIndicator, @JsonProperty(value="metAreaCode") MetAreaCode metAreaCode, @JsonProperty(value="coastalWarningAreaCode") String coastalWarningAreaCode) {
        if (Globals.config().validateInConstructor().test(MetCoastalWarningArea.class)) {
            Preconditions.checkNotNull((Object)((Object)subjectIndicator), (String)"subjectIndicator");
            Preconditions.checkNotNull((Object)metAreaCode, (String)"metAreaCode");
            Preconditions.checkNotNull((Object)coastalWarningAreaCode, (String)"coastalWarningAreaCode");
            Preconditions.checkMatchesPattern((String)coastalWarningAreaCode, (String)"[a-zA-Z]", (String)"coastalWarningAreaCode");
        }
        this.subjectIndicator = subjectIndicator;
        this.metAreaCode = metAreaCode;
        this.coastalWarningAreaCode = coastalWarningAreaCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SubjectIndicator subjectIndicator() {
        return this.subjectIndicator;
    }

    public MetAreaCode metAreaCode() {
        return this.metAreaCode;
    }

    public String coastalWarningAreaCode() {
        return this.coastalWarningAreaCode;
    }

    public MetCoastalWarningArea withSubjectIndicator(SubjectIndicator subjectIndicator) {
        return new MetCoastalWarningArea(subjectIndicator, this.metAreaCode, this.coastalWarningAreaCode);
    }

    public MetCoastalWarningArea withMetAreaCode(MetAreaCode metAreaCode) {
        return new MetCoastalWarningArea(this.subjectIndicator, metAreaCode, this.coastalWarningAreaCode);
    }

    public MetCoastalWarningArea withCoastalWarningAreaCode(String coastalWarningAreaCode) {
        return new MetCoastalWarningArea(this.subjectIndicator, this.metAreaCode, coastalWarningAreaCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetCoastalWarningArea other = (MetCoastalWarningArea)o;
        return Objects.equals((Object)this.subjectIndicator, (Object)other.subjectIndicator) && Objects.equals(this.metAreaCode, other.metAreaCode) && Objects.equals(this.coastalWarningAreaCode, other.coastalWarningAreaCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subjectIndicator, this.metAreaCode, this.coastalWarningAreaCode});
    }

    public String toString() {
        return Util.toString(MetCoastalWarningArea.class, (Object[])new Object[]{"subjectIndicator", this.subjectIndicator, "metAreaCode", this.metAreaCode, "coastalWarningAreaCode", this.coastalWarningAreaCode});
    }

    public static final class BuilderWithCoastalWarningAreaCode {
        private final Builder b;

        BuilderWithCoastalWarningAreaCode(Builder b) {
            this.b = b;
        }

        public MetCoastalWarningArea build() {
            return new MetCoastalWarningArea(this.b.subjectIndicator, this.b.metAreaCode, this.b.coastalWarningAreaCode);
        }
    }

    public static final class BuilderWithMetAreaCode {
        private final Builder b;

        BuilderWithMetAreaCode(Builder b) {
            this.b = b;
        }

        public BuilderWithCoastalWarningAreaCode coastalWarningAreaCode(String coastalWarningAreaCode) {
            this.b.coastalWarningAreaCode = coastalWarningAreaCode;
            return new BuilderWithCoastalWarningAreaCode(this.b);
        }
    }

    public static final class BuilderWithSubjectIndicator {
        private final Builder b;

        BuilderWithSubjectIndicator(Builder b) {
            this.b = b;
        }

        public BuilderWithMetAreaCode metAreaCode(MetAreaCode metAreaCode) {
            this.b.metAreaCode = metAreaCode;
            return new BuilderWithMetAreaCode(this.b);
        }
    }

    public static final class Builder {
        private SubjectIndicator subjectIndicator;
        private MetAreaCode metAreaCode;
        private String coastalWarningAreaCode;

        Builder() {
        }

        public BuilderWithSubjectIndicator subjectIndicator(SubjectIndicator subjectIndicator) {
            this.subjectIndicator = subjectIndicator;
            return new BuilderWithSubjectIndicator(this);
        }
    }
}

