/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class MinMaxLength {
    @JsonProperty(value="first")
    private final String first;
    @JsonProperty(value="second")
    private final String second;

    @JsonCreator
    private MinMaxLength(@JsonProperty(value="first") String first, @JsonProperty(value="second") String second) {
        if (Globals.config().validateInConstructor().test(MinMaxLength.class)) {
            Preconditions.checkMinLength((String)first, (int)1, (String)"first");
            Preconditions.checkMaxLength((String)first, (int)3, (String)"first");
            Preconditions.checkMinLength((String)second, (int)2, (String)"second");
            Preconditions.checkMaxLength((String)second, (int)3, (String)"second");
        }
        this.first = first;
        this.second = second;
    }

    @ConstructorBinding
    public MinMaxLength(String first, Optional<String> second) {
        if (Globals.config().validateInConstructor().test(MinMaxLength.class)) {
            Preconditions.checkNotNull((Object)first, (String)"first");
            Preconditions.checkMinLength((String)first, (int)1, (String)"first");
            Preconditions.checkMaxLength((String)first, (int)3, (String)"first");
            Preconditions.checkNotNull(second, (String)"second");
            Preconditions.checkMinLength(second, (int)2, (String)"second");
            Preconditions.checkMaxLength(second, (int)3, (String)"second");
        }
        this.first = first;
        this.second = second.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String first() {
        return this.first;
    }

    public Optional<String> second() {
        return Optional.ofNullable(this.second);
    }

    public MinMaxLength withFirst(String first) {
        return new MinMaxLength(first, Optional.ofNullable(this.second));
    }

    public MinMaxLength withSecond(Optional<String> second) {
        return new MinMaxLength(this.first, second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinMaxLength other = (MinMaxLength)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return Util.toString(MinMaxLength.class, (Object[])new Object[]{"first", this.first, "second", this.second});
    }

    public static final class BuilderWithFirst {
        private final Builder b;

        BuilderWithFirst(Builder b) {
            this.b = b;
        }

        public BuilderWithFirst second(String second) {
            this.b.second = Optional.of(second);
            return this;
        }

        public BuilderWithFirst second(Optional<String> second) {
            this.b.second = second;
            return this;
        }

        public MinMaxLength build() {
            return new MinMaxLength(this.b.first, this.b.second);
        }
    }

    public static final class Builder {
        private String first;
        private Optional<String> second = Optional.empty();

        Builder() {
        }

        public BuilderWithFirst first(String first) {
            this.first = first;
            return new BuilderWithFirst(this);
        }
    }
}

