/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class MixRequiredAndNotRequiredWithConstraint {
    @JsonProperty(value="a")
    private final String a;
    @JsonProperty(value="b")
    private final Integer b;

    @JsonCreator
    private MixRequiredAndNotRequiredWithConstraint(@JsonProperty(value="a") String a, @JsonProperty(value="b") Integer b) {
        if (Globals.config().validateInConstructor().test(MixRequiredAndNotRequiredWithConstraint.class)) {
            Preconditions.checkMinLength((String)a, (int)3, (String)"a");
            Preconditions.checkMinimum((Number)b, (String)"10", (String)"b", (boolean)false);
        }
        this.a = a;
        this.b = b;
    }

    @ConstructorBinding
    public MixRequiredAndNotRequiredWithConstraint(String a, Optional<Integer> b) {
        if (Globals.config().validateInConstructor().test(MixRequiredAndNotRequiredWithConstraint.class)) {
            Preconditions.checkNotNull((Object)a, (String)"a");
            Preconditions.checkMinLength((String)a, (int)3, (String)"a");
            Preconditions.checkNotNull(b, (String)"b");
            Preconditions.checkMinimum(b, (String)"10", (String)"b", (boolean)false);
        }
        this.a = a;
        this.b = b.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String a() {
        return this.a;
    }

    public Optional<Integer> b() {
        return Optional.ofNullable(this.b);
    }

    public MixRequiredAndNotRequiredWithConstraint withA(String a) {
        return new MixRequiredAndNotRequiredWithConstraint(a, Optional.ofNullable(this.b));
    }

    public MixRequiredAndNotRequiredWithConstraint withB(Optional<Integer> b) {
        return new MixRequiredAndNotRequiredWithConstraint(this.a, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MixRequiredAndNotRequiredWithConstraint other = (MixRequiredAndNotRequiredWithConstraint)o;
        return Objects.equals(this.a, other.a) && Objects.equals(this.b, other.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public String toString() {
        return Util.toString(MixRequiredAndNotRequiredWithConstraint.class, (Object[])new Object[]{"a", this.a, "b", this.b});
    }

    public static final class BuilderWithA {
        private final Builder b;

        BuilderWithA(Builder b) {
            this.b = b;
        }

        public BuilderWithA b(int b) {
            this.b.b = Optional.of(b);
            return this;
        }

        public BuilderWithA b(Optional<Integer> b) {
            this.b.b = b;
            return this;
        }

        public MixRequiredAndNotRequiredWithConstraint build() {
            return new MixRequiredAndNotRequiredWithConstraint(this.b.a, this.b.b);
        }
    }

    public static final class Builder {
        private String a;
        private Optional<Integer> b = Optional.empty();

        Builder() {
        }

        public BuilderWithA a(String a) {
            this.a = a;
            return new BuilderWithA(this);
        }
    }
}

