/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Broadcast;
import org.davidmoten.oa3.codegen.test.main.schema.MsiId;
import org.davidmoten.oa3.codegen.test.main.schema.Payload;
import org.davidmoten.oa3.codegen.test.main.schema.Repetition;
import org.davidmoten.oa3.codegen.test.main.schema.Status;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Msi {
    @JsonProperty(value="id")
    private final MsiId id;
    @JsonProperty(value="broadcast")
    private final Broadcast broadcast;
    @JsonProperty(value="createdTime")
    private final OffsetDateTime createdTime;
    @JsonProperty(value="cancelledTime")
    private final OffsetDateTime cancelledTime;
    @JsonProperty(value="startTime")
    private final OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private final OffsetDateTime endTime;
    @JsonProperty(value="payload")
    private final Payload payload;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="echo")
    private final Boolean echo;
    @JsonProperty(value="repetition")
    private final Repetition repetition;
    @JsonProperty(value="readAcksEnabled")
    private final Boolean readAcksEnabled;
    @JsonProperty(value="receiveAcksEnabled")
    private final Boolean receiveAcksEnabled;

    @JsonCreator
    private Msi(@JsonProperty(value="id") MsiId id, @JsonProperty(value="broadcast") Broadcast broadcast, @JsonProperty(value="createdTime") OffsetDateTime createdTime, @JsonProperty(value="cancelledTime") OffsetDateTime cancelledTime, @JsonProperty(value="startTime") OffsetDateTime startTime, @JsonProperty(value="endTime") OffsetDateTime endTime, @JsonProperty(value="payload") Payload payload, @JsonProperty(value="status") Status status, @JsonProperty(value="echo") Boolean echo, @JsonProperty(value="repetition") Repetition repetition, @JsonProperty(value="readAcksEnabled") Boolean readAcksEnabled, @JsonProperty(value="receiveAcksEnabled") Boolean receiveAcksEnabled) {
        this.id = id;
        this.broadcast = broadcast;
        this.createdTime = createdTime;
        this.cancelledTime = cancelledTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.payload = payload;
        this.status = status;
        this.echo = echo;
        this.repetition = repetition;
        this.readAcksEnabled = readAcksEnabled;
        this.receiveAcksEnabled = receiveAcksEnabled;
    }

    @ConstructorBinding
    public Msi(MsiId id, Broadcast broadcast, OffsetDateTime createdTime, Optional<OffsetDateTime> cancelledTime, OffsetDateTime startTime, OffsetDateTime endTime, Payload payload, Status status, Optional<Boolean> echo, Optional<Repetition> repetition, Optional<Boolean> readAcksEnabled, Optional<Boolean> receiveAcksEnabled) {
        if (Globals.config().validateInConstructor().test(Msi.class)) {
            Preconditions.checkNotNull((Object)id, (String)"id");
            Preconditions.checkNotNull((Object)broadcast, (String)"broadcast");
            Preconditions.checkNotNull((Object)createdTime, (String)"createdTime");
            Preconditions.checkNotNull(cancelledTime, (String)"cancelledTime");
            Preconditions.checkNotNull((Object)startTime, (String)"startTime");
            Preconditions.checkNotNull((Object)endTime, (String)"endTime");
            Preconditions.checkNotNull((Object)payload, (String)"payload");
            Preconditions.checkNotNull((Object)((Object)status), (String)"status");
            Preconditions.checkNotNull(echo, (String)"echo");
            Preconditions.checkNotNull(repetition, (String)"repetition");
            Preconditions.checkNotNull(readAcksEnabled, (String)"readAcksEnabled");
            Preconditions.checkNotNull(receiveAcksEnabled, (String)"receiveAcksEnabled");
        }
        this.id = id;
        this.broadcast = broadcast;
        this.createdTime = createdTime;
        this.cancelledTime = cancelledTime.orElse(null);
        this.startTime = startTime;
        this.endTime = endTime;
        this.payload = payload;
        this.status = status;
        this.echo = echo.orElse(null);
        this.repetition = repetition.orElse(null);
        this.readAcksEnabled = readAcksEnabled.orElse(null);
        this.receiveAcksEnabled = receiveAcksEnabled.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public MsiId id() {
        return this.id;
    }

    public Broadcast broadcast() {
        return this.broadcast;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public Optional<OffsetDateTime> cancelledTime() {
        return Optional.ofNullable(this.cancelledTime);
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public Payload payload() {
        return this.payload;
    }

    public Status status() {
        return this.status;
    }

    public Optional<Boolean> echo() {
        return Optional.ofNullable(this.echo);
    }

    public Optional<Repetition> repetition() {
        return Optional.ofNullable(this.repetition);
    }

    public Optional<Boolean> readAcksEnabled() {
        return Optional.ofNullable(this.readAcksEnabled);
    }

    public Optional<Boolean> receiveAcksEnabled() {
        return Optional.ofNullable(this.receiveAcksEnabled);
    }

    public Msi withId(MsiId id) {
        return new Msi(id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withBroadcast(Broadcast broadcast) {
        return new Msi(this.id, broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withCreatedTime(OffsetDateTime createdTime) {
        return new Msi(this.id, this.broadcast, createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withCancelledTime(Optional<OffsetDateTime> cancelledTime) {
        return new Msi(this.id, this.broadcast, this.createdTime, cancelledTime, this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withStartTime(OffsetDateTime startTime) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withEndTime(OffsetDateTime endTime) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withPayload(Payload payload) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withStatus(Status status) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withEcho(Optional<Boolean> echo) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, echo, Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withRepetition(Optional<Repetition> repetition) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), repetition, Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withReadAcksEnabled(Optional<Boolean> readAcksEnabled) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), readAcksEnabled, Optional.ofNullable(this.receiveAcksEnabled));
    }

    public Msi withReceiveAcksEnabled(Optional<Boolean> receiveAcksEnabled) {
        return new Msi(this.id, this.broadcast, this.createdTime, Optional.ofNullable(this.cancelledTime), this.startTime, this.endTime, this.payload, this.status, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), receiveAcksEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Msi other = (Msi)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.broadcast, other.broadcast) && Objects.equals(this.createdTime, other.createdTime) && Objects.equals(this.cancelledTime, other.cancelledTime) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.payload, other.payload) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.echo, other.echo) && Objects.equals(this.repetition, other.repetition) && Objects.equals(this.readAcksEnabled, other.readAcksEnabled) && Objects.equals(this.receiveAcksEnabled, other.receiveAcksEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.broadcast, this.createdTime, this.cancelledTime, this.startTime, this.endTime, this.payload, this.status, this.echo, this.repetition, this.readAcksEnabled, this.receiveAcksEnabled});
    }

    public String toString() {
        return Util.toString(Msi.class, (Object[])new Object[]{"id", this.id, "broadcast", this.broadcast, "createdTime", this.createdTime, "cancelledTime", this.cancelledTime, "startTime", this.startTime, "endTime", this.endTime, "payload", this.payload, "status", this.status, "echo", this.echo, "repetition", this.repetition, "readAcksEnabled", this.readAcksEnabled, "receiveAcksEnabled", this.receiveAcksEnabled});
    }

    public static final class BuilderWithStatus {
        private final Builder b;

        BuilderWithStatus(Builder b) {
            this.b = b;
        }

        public BuilderWithStatus cancelledTime(OffsetDateTime cancelledTime) {
            this.b.cancelledTime = Optional.of(cancelledTime);
            return this;
        }

        public BuilderWithStatus cancelledTime(Optional<OffsetDateTime> cancelledTime) {
            this.b.cancelledTime = cancelledTime;
            return this;
        }

        public BuilderWithStatus echo(boolean echo) {
            this.b.echo = Optional.of(echo);
            return this;
        }

        public BuilderWithStatus echo(Optional<Boolean> echo) {
            this.b.echo = echo;
            return this;
        }

        public BuilderWithStatus repetition(Repetition repetition) {
            this.b.repetition = Optional.of(repetition);
            return this;
        }

        public BuilderWithStatus repetition(Optional<Repetition> repetition) {
            this.b.repetition = repetition;
            return this;
        }

        public BuilderWithStatus readAcksEnabled(boolean readAcksEnabled) {
            this.b.readAcksEnabled = Optional.of(readAcksEnabled);
            return this;
        }

        public BuilderWithStatus readAcksEnabled(Optional<Boolean> readAcksEnabled) {
            this.b.readAcksEnabled = readAcksEnabled;
            return this;
        }

        public BuilderWithStatus receiveAcksEnabled(boolean receiveAcksEnabled) {
            this.b.receiveAcksEnabled = Optional.of(receiveAcksEnabled);
            return this;
        }

        public BuilderWithStatus receiveAcksEnabled(Optional<Boolean> receiveAcksEnabled) {
            this.b.receiveAcksEnabled = receiveAcksEnabled;
            return this;
        }

        public Msi build() {
            return new Msi(this.b.id, this.b.broadcast, this.b.createdTime, this.b.cancelledTime, this.b.startTime, this.b.endTime, this.b.payload, this.b.status, this.b.echo, this.b.repetition, this.b.readAcksEnabled, this.b.receiveAcksEnabled);
        }
    }

    public static final class BuilderWithPayload {
        private final Builder b;

        BuilderWithPayload(Builder b) {
            this.b = b;
        }

        public BuilderWithStatus status(Status status) {
            this.b.status = status;
            return new BuilderWithStatus(this.b);
        }
    }

    public static final class BuilderWithEndTime {
        private final Builder b;

        BuilderWithEndTime(Builder b) {
            this.b = b;
        }

        public BuilderWithPayload payload(Payload payload) {
            this.b.payload = payload;
            return new BuilderWithPayload(this.b);
        }
    }

    public static final class BuilderWithStartTime {
        private final Builder b;

        BuilderWithStartTime(Builder b) {
            this.b = b;
        }

        public BuilderWithEndTime endTime(OffsetDateTime endTime) {
            this.b.endTime = endTime;
            return new BuilderWithEndTime(this.b);
        }
    }

    public static final class BuilderWithCreatedTime {
        private final Builder b;

        BuilderWithCreatedTime(Builder b) {
            this.b = b;
        }

        public BuilderWithStartTime startTime(OffsetDateTime startTime) {
            this.b.startTime = startTime;
            return new BuilderWithStartTime(this.b);
        }
    }

    public static final class BuilderWithBroadcast {
        private final Builder b;

        BuilderWithBroadcast(Builder b) {
            this.b = b;
        }

        public BuilderWithCreatedTime createdTime(OffsetDateTime createdTime) {
            this.b.createdTime = createdTime;
            return new BuilderWithCreatedTime(this.b);
        }
    }

    public static final class BuilderWithId {
        private final Builder b;

        BuilderWithId(Builder b) {
            this.b = b;
        }

        public BuilderWithBroadcast broadcast(Broadcast broadcast) {
            this.b.broadcast = broadcast;
            return new BuilderWithBroadcast(this.b);
        }
    }

    public static final class Builder {
        private MsiId id;
        private Broadcast broadcast;
        private OffsetDateTime createdTime;
        private OffsetDateTime startTime;
        private OffsetDateTime endTime;
        private Payload payload;
        private Status status;
        private Optional<OffsetDateTime> cancelledTime = Optional.empty();
        private Optional<Boolean> echo = Optional.empty();
        private Optional<Repetition> repetition = Optional.empty();
        private Optional<Boolean> readAcksEnabled = Optional.empty();
        private Optional<Boolean> receiveAcksEnabled = Optional.empty();

        Builder() {
        }

        public BuilderWithId id(MsiId id) {
            this.id = id;
            return new BuilderWithId(this);
        }
    }
}

