/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Broadcast;
import org.davidmoten.oa3.codegen.test.main.schema.Payload;
import org.davidmoten.oa3.codegen.test.main.schema.Repetition;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class MsiContent {
    @JsonProperty(value="broadcast")
    private final Broadcast broadcast;
    @JsonProperty(value="startTime")
    private final OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private final OffsetDateTime endTime;
    @JsonProperty(value="payload")
    private final Payload payload;
    @JsonProperty(value="echo")
    private final Boolean echo;
    @JsonProperty(value="repetition")
    private final Repetition repetition;
    @JsonProperty(value="readAcksEnabled")
    private final Boolean readAcksEnabled;
    @JsonProperty(value="receiveAcksEnabled")
    private final Boolean receiveAcksEnabled;

    @JsonCreator
    private MsiContent(@JsonProperty(value="broadcast") Broadcast broadcast, @JsonProperty(value="startTime") OffsetDateTime startTime, @JsonProperty(value="endTime") OffsetDateTime endTime, @JsonProperty(value="payload") Payload payload, @JsonProperty(value="echo") Boolean echo, @JsonProperty(value="repetition") Repetition repetition, @JsonProperty(value="readAcksEnabled") Boolean readAcksEnabled, @JsonProperty(value="receiveAcksEnabled") Boolean receiveAcksEnabled) {
        this.broadcast = broadcast;
        this.startTime = startTime;
        this.endTime = endTime;
        this.payload = payload;
        this.echo = echo;
        this.repetition = repetition;
        this.readAcksEnabled = readAcksEnabled;
        this.receiveAcksEnabled = receiveAcksEnabled;
    }

    @ConstructorBinding
    public MsiContent(Broadcast broadcast, Optional<OffsetDateTime> startTime, Optional<OffsetDateTime> endTime, Payload payload, Optional<Boolean> echo, Optional<Repetition> repetition, Optional<Boolean> readAcksEnabled, Optional<Boolean> receiveAcksEnabled) {
        if (Globals.config().validateInConstructor().test(MsiContent.class)) {
            Preconditions.checkNotNull((Object)broadcast, (String)"broadcast");
            Preconditions.checkNotNull(startTime, (String)"startTime");
            Preconditions.checkNotNull(endTime, (String)"endTime");
            Preconditions.checkNotNull((Object)payload, (String)"payload");
            Preconditions.checkNotNull(echo, (String)"echo");
            Preconditions.checkNotNull(repetition, (String)"repetition");
            Preconditions.checkNotNull(readAcksEnabled, (String)"readAcksEnabled");
            Preconditions.checkNotNull(receiveAcksEnabled, (String)"receiveAcksEnabled");
        }
        this.broadcast = broadcast;
        this.startTime = startTime.orElse(null);
        this.endTime = endTime.orElse(null);
        this.payload = payload;
        this.echo = echo.orElse(null);
        this.repetition = repetition.orElse(null);
        this.readAcksEnabled = readAcksEnabled.orElse(null);
        this.receiveAcksEnabled = receiveAcksEnabled.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Broadcast broadcast() {
        return this.broadcast;
    }

    public Optional<OffsetDateTime> startTime() {
        return Optional.ofNullable(this.startTime);
    }

    public Optional<OffsetDateTime> endTime() {
        return Optional.ofNullable(this.endTime);
    }

    public Payload payload() {
        return this.payload;
    }

    public Optional<Boolean> echo() {
        return Optional.ofNullable(this.echo);
    }

    public Optional<Repetition> repetition() {
        return Optional.ofNullable(this.repetition);
    }

    public Optional<Boolean> readAcksEnabled() {
        return Optional.ofNullable(this.readAcksEnabled);
    }

    public Optional<Boolean> receiveAcksEnabled() {
        return Optional.ofNullable(this.receiveAcksEnabled);
    }

    public MsiContent withBroadcast(Broadcast broadcast) {
        return new MsiContent(broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), this.payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withStartTime(Optional<OffsetDateTime> startTime) {
        return new MsiContent(this.broadcast, startTime, Optional.ofNullable(this.endTime), this.payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withEndTime(Optional<OffsetDateTime> endTime) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), endTime, this.payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withPayload(Payload payload) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withEcho(Optional<Boolean> echo) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), this.payload, echo, Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withRepetition(Optional<Repetition> repetition) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), this.payload, Optional.ofNullable(this.echo), repetition, Optional.ofNullable(this.readAcksEnabled), Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withReadAcksEnabled(Optional<Boolean> readAcksEnabled) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), this.payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), readAcksEnabled, Optional.ofNullable(this.receiveAcksEnabled));
    }

    public MsiContent withReceiveAcksEnabled(Optional<Boolean> receiveAcksEnabled) {
        return new MsiContent(this.broadcast, Optional.ofNullable(this.startTime), Optional.ofNullable(this.endTime), this.payload, Optional.ofNullable(this.echo), Optional.ofNullable(this.repetition), Optional.ofNullable(this.readAcksEnabled), receiveAcksEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MsiContent other = (MsiContent)o;
        return Objects.equals(this.broadcast, other.broadcast) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.payload, other.payload) && Objects.equals(this.echo, other.echo) && Objects.equals(this.repetition, other.repetition) && Objects.equals(this.readAcksEnabled, other.readAcksEnabled) && Objects.equals(this.receiveAcksEnabled, other.receiveAcksEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.broadcast, this.startTime, this.endTime, this.payload, this.echo, this.repetition, this.readAcksEnabled, this.receiveAcksEnabled);
    }

    public String toString() {
        return Util.toString(MsiContent.class, (Object[])new Object[]{"broadcast", this.broadcast, "startTime", this.startTime, "endTime", this.endTime, "payload", this.payload, "echo", this.echo, "repetition", this.repetition, "readAcksEnabled", this.readAcksEnabled, "receiveAcksEnabled", this.receiveAcksEnabled});
    }

    public static final class BuilderWithPayload {
        private final Builder b;

        BuilderWithPayload(Builder b) {
            this.b = b;
        }

        public BuilderWithPayload startTime(OffsetDateTime startTime) {
            this.b.startTime = Optional.of(startTime);
            return this;
        }

        public BuilderWithPayload startTime(Optional<OffsetDateTime> startTime) {
            this.b.startTime = startTime;
            return this;
        }

        public BuilderWithPayload endTime(OffsetDateTime endTime) {
            this.b.endTime = Optional.of(endTime);
            return this;
        }

        public BuilderWithPayload endTime(Optional<OffsetDateTime> endTime) {
            this.b.endTime = endTime;
            return this;
        }

        public BuilderWithPayload echo(boolean echo) {
            this.b.echo = Optional.of(echo);
            return this;
        }

        public BuilderWithPayload echo(Optional<Boolean> echo) {
            this.b.echo = echo;
            return this;
        }

        public BuilderWithPayload repetition(Repetition repetition) {
            this.b.repetition = Optional.of(repetition);
            return this;
        }

        public BuilderWithPayload repetition(Optional<Repetition> repetition) {
            this.b.repetition = repetition;
            return this;
        }

        public BuilderWithPayload readAcksEnabled(boolean readAcksEnabled) {
            this.b.readAcksEnabled = Optional.of(readAcksEnabled);
            return this;
        }

        public BuilderWithPayload readAcksEnabled(Optional<Boolean> readAcksEnabled) {
            this.b.readAcksEnabled = readAcksEnabled;
            return this;
        }

        public BuilderWithPayload receiveAcksEnabled(boolean receiveAcksEnabled) {
            this.b.receiveAcksEnabled = Optional.of(receiveAcksEnabled);
            return this;
        }

        public BuilderWithPayload receiveAcksEnabled(Optional<Boolean> receiveAcksEnabled) {
            this.b.receiveAcksEnabled = receiveAcksEnabled;
            return this;
        }

        public MsiContent build() {
            return new MsiContent(this.b.broadcast, this.b.startTime, this.b.endTime, this.b.payload, this.b.echo, this.b.repetition, this.b.readAcksEnabled, this.b.receiveAcksEnabled);
        }
    }

    public static final class BuilderWithBroadcast {
        private final Builder b;

        BuilderWithBroadcast(Builder b) {
            this.b = b;
        }

        public BuilderWithPayload payload(Payload payload) {
            this.b.payload = payload;
            return new BuilderWithPayload(this.b);
        }
    }

    public static final class Builder {
        private Broadcast broadcast;
        private Payload payload;
        private Optional<OffsetDateTime> startTime = Optional.empty();
        private Optional<OffsetDateTime> endTime = Optional.empty();
        private Optional<Boolean> echo = Optional.empty();
        private Optional<Repetition> repetition = Optional.empty();
        private Optional<Boolean> readAcksEnabled = Optional.empty();
        private Optional<Boolean> receiveAcksEnabled = Optional.empty();

        Builder() {
        }

        public BuilderWithBroadcast broadcast(Broadcast broadcast) {
            this.broadcast = broadcast;
            return new BuilderWithBroadcast(this);
        }
    }
}

