/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.NavAreaCode;
import org.davidmoten.oa3.codegen.test.main.schema.SubjectIndicator;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class NavCoastalWarningArea {
    @JsonProperty(value="subjectIndicator")
    private final SubjectIndicator subjectIndicator;
    @JsonProperty(value="navAreaCode")
    private final NavAreaCode navAreaCode;
    @JsonProperty(value="coastalWarningAreaCode")
    private final String coastalWarningAreaCode;

    @JsonCreator
    @ConstructorBinding
    public NavCoastalWarningArea(@JsonProperty(value="subjectIndicator") SubjectIndicator subjectIndicator, @JsonProperty(value="navAreaCode") NavAreaCode navAreaCode, @JsonProperty(value="coastalWarningAreaCode") String coastalWarningAreaCode) {
        if (Globals.config().validateInConstructor().test(NavCoastalWarningArea.class)) {
            Preconditions.checkNotNull((Object)((Object)subjectIndicator), (String)"subjectIndicator");
            Preconditions.checkNotNull((Object)navAreaCode, (String)"navAreaCode");
            Preconditions.checkNotNull((Object)coastalWarningAreaCode, (String)"coastalWarningAreaCode");
            Preconditions.checkMatchesPattern((String)coastalWarningAreaCode, (String)"[a-zA-Z]", (String)"coastalWarningAreaCode");
        }
        this.subjectIndicator = subjectIndicator;
        this.navAreaCode = navAreaCode;
        this.coastalWarningAreaCode = coastalWarningAreaCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SubjectIndicator subjectIndicator() {
        return this.subjectIndicator;
    }

    public NavAreaCode navAreaCode() {
        return this.navAreaCode;
    }

    public String coastalWarningAreaCode() {
        return this.coastalWarningAreaCode;
    }

    public NavCoastalWarningArea withSubjectIndicator(SubjectIndicator subjectIndicator) {
        return new NavCoastalWarningArea(subjectIndicator, this.navAreaCode, this.coastalWarningAreaCode);
    }

    public NavCoastalWarningArea withNavAreaCode(NavAreaCode navAreaCode) {
        return new NavCoastalWarningArea(this.subjectIndicator, navAreaCode, this.coastalWarningAreaCode);
    }

    public NavCoastalWarningArea withCoastalWarningAreaCode(String coastalWarningAreaCode) {
        return new NavCoastalWarningArea(this.subjectIndicator, this.navAreaCode, coastalWarningAreaCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavCoastalWarningArea other = (NavCoastalWarningArea)o;
        return Objects.equals((Object)this.subjectIndicator, (Object)other.subjectIndicator) && Objects.equals(this.navAreaCode, other.navAreaCode) && Objects.equals(this.coastalWarningAreaCode, other.coastalWarningAreaCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subjectIndicator, this.navAreaCode, this.coastalWarningAreaCode});
    }

    public String toString() {
        return Util.toString(NavCoastalWarningArea.class, (Object[])new Object[]{"subjectIndicator", this.subjectIndicator, "navAreaCode", this.navAreaCode, "coastalWarningAreaCode", this.coastalWarningAreaCode});
    }

    public static final class BuilderWithCoastalWarningAreaCode {
        private final Builder b;

        BuilderWithCoastalWarningAreaCode(Builder b) {
            this.b = b;
        }

        public NavCoastalWarningArea build() {
            return new NavCoastalWarningArea(this.b.subjectIndicator, this.b.navAreaCode, this.b.coastalWarningAreaCode);
        }
    }

    public static final class BuilderWithNavAreaCode {
        private final Builder b;

        BuilderWithNavAreaCode(Builder b) {
            this.b = b;
        }

        public BuilderWithCoastalWarningAreaCode coastalWarningAreaCode(String coastalWarningAreaCode) {
            this.b.coastalWarningAreaCode = coastalWarningAreaCode;
            return new BuilderWithCoastalWarningAreaCode(this.b);
        }
    }

    public static final class BuilderWithSubjectIndicator {
        private final Builder b;

        BuilderWithSubjectIndicator(Builder b) {
            this.b = b;
        }

        public BuilderWithNavAreaCode navAreaCode(NavAreaCode navAreaCode) {
            this.b.navAreaCode = navAreaCode;
            return new BuilderWithNavAreaCode(this.b);
        }
    }

    public static final class Builder {
        private SubjectIndicator subjectIndicator;
        private NavAreaCode navAreaCode;
        private String coastalWarningAreaCode;

        Builder() {
        }

        public BuilderWithSubjectIndicator subjectIndicator(SubjectIndicator subjectIndicator) {
            this.subjectIndicator = subjectIndicator;
            return new BuilderWithSubjectIndicator(this);
        }
    }
}

