/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Nested {
    @JsonProperty(value="first")
    private final First first;
    @JsonProperty(value="second")
    private final String second;

    @JsonCreator
    private Nested(@JsonProperty(value="first") First first, @JsonProperty(value="second") String second) {
        this.first = first;
        this.second = second;
    }

    @ConstructorBinding
    public Nested(Optional<First> first, Optional<String> second) {
        if (Globals.config().validateInConstructor().test(Nested.class)) {
            Preconditions.checkNotNull(first, (String)"first");
            Preconditions.checkNotNull(second, (String)"second");
        }
        this.first = first.orElse(null);
        this.second = second.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<First> first() {
        return Optional.ofNullable(this.first);
    }

    public Optional<String> second() {
        return Optional.ofNullable(this.second);
    }

    public Nested withFirst(Optional<First> first) {
        return new Nested(first, Optional.ofNullable(this.second));
    }

    public Nested withSecond(Optional<String> second) {
        return new Nested(Optional.ofNullable(this.first), second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nested other = (Nested)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return Util.toString(Nested.class, (Object[])new Object[]{"first", this.first, "second", this.second});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class First {
        @JsonProperty(value="first2")
        private final First2 first2;
        @JsonProperty(value="second2")
        private final Second2 second2;

        @JsonCreator
        private First(@JsonProperty(value="first2") First2 first2, @JsonProperty(value="second2") Second2 second2) {
            this.first2 = first2;
            this.second2 = second2;
        }

        @ConstructorBinding
        public First(Optional<First2> first2, Optional<Second2> second2) {
            if (Globals.config().validateInConstructor().test(First.class)) {
                Preconditions.checkNotNull(first2, (String)"first2");
                Preconditions.checkNotNull(second2, (String)"second2");
            }
            this.first2 = first2.orElse(null);
            this.second2 = second2.orElse(null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public Optional<First2> first2() {
            return Optional.ofNullable(this.first2);
        }

        public Optional<Second2> second2() {
            return Optional.ofNullable(this.second2);
        }

        public First withFirst2(Optional<First2> first2) {
            return new First(first2, Optional.ofNullable(this.second2));
        }

        public First withSecond2(Optional<Second2> second2) {
            return new First(Optional.ofNullable(this.first2), second2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            First other = (First)o;
            return Objects.equals(this.first2, other.first2) && Objects.equals(this.second2, other.second2);
        }

        public int hashCode() {
            return Objects.hash(this.first2, this.second2);
        }

        public String toString() {
            return Util.toString(First.class, (Object[])new Object[]{"first2", this.first2, "second2", this.second2});
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
        public static final class Second2 {
            @JsonValue
            private final List<Second2Item> value;

            @JsonCreator
            @ConstructorBinding
            public Second2(List<Second2Item> value) {
                if (Globals.config().validateInConstructor().test(Second2.class)) {
                    Preconditions.checkNotNull(value, (String)"value");
                }
                this.value = value;
            }

            public static Second2 value(List<Second2Item> value) {
                return new Second2(value);
            }

            public List<Second2Item> value() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Second2 other = (Second2)o;
                return Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public String toString() {
                return Util.toString(Second2.class, (Object[])new Object[]{"value", this.value});
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
            public static final class Second2Item {
                @JsonProperty(value="partNumber")
                private final int partNumber;

                @JsonCreator
                @ConstructorBinding
                public Second2Item(@JsonProperty(value="partNumber") int partNumber) {
                    this.partNumber = partNumber;
                }

                public static Second2Item partNumber(int partNumber) {
                    return new Second2Item(partNumber);
                }

                public int partNumber() {
                    return this.partNumber;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Second2Item other = (Second2Item)o;
                    return Objects.equals(this.partNumber, other.partNumber);
                }

                public int hashCode() {
                    return Objects.hash(this.partNumber);
                }

                public String toString() {
                    return Util.toString(Second2Item.class, (Object[])new Object[]{"partNumber", this.partNumber});
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
        public static final class First2 {
            @JsonProperty(value="first3")
            private final String first3;

            @JsonCreator
            private First2(@JsonProperty(value="first3") String first3) {
                this.first3 = first3;
            }

            @ConstructorBinding
            public First2(Optional<String> first3) {
                if (Globals.config().validateInConstructor().test(First2.class)) {
                    Preconditions.checkNotNull(first3, (String)"first3");
                }
                this.first3 = first3.orElse(null);
            }

            public static First2 first3(Optional<String> first3) {
                return new First2(first3);
            }

            public static First2 first3(String first3) {
                return new First2(Optional.of(first3));
            }

            public Optional<String> first3() {
                return Optional.ofNullable(this.first3);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                First2 other = (First2)o;
                return Objects.equals(this.first3, other.first3);
            }

            public int hashCode() {
                return Objects.hash(this.first3);
            }

            public String toString() {
                return Util.toString(First2.class, (Object[])new Object[]{"first3", this.first3});
            }
        }

        public static final class Builder {
            private Optional<First2> first2 = Optional.empty();
            private Optional<Second2> second2 = Optional.empty();

            Builder() {
            }

            public Builder first2(First2 first2) {
                this.first2 = Optional.of(first2);
                return this;
            }

            public Builder first2(Optional<First2> first2) {
                this.first2 = first2;
                return this;
            }

            public Builder second2(Second2 second2) {
                this.second2 = Optional.of(second2);
                return this;
            }

            public Builder second2(Optional<Second2> second2) {
                this.second2 = second2;
                return this;
            }

            public First build() {
                return new First(this.first2, this.second2);
            }
        }
    }

    public static final class Builder {
        private Optional<First> first = Optional.empty();
        private Optional<String> second = Optional.empty();

        Builder() {
        }

        public Builder first(First first) {
            this.first = Optional.of(first);
            return this;
        }

        public Builder first(Optional<First> first) {
            this.first = first;
            return this;
        }

        public Builder second(String second) {
            this.second = Optional.of(second);
            return this;
        }

        public Builder second(Optional<String> second) {
            this.second = second;
            return this;
        }

        public Nested build() {
            return new Nested(this.first, this.second);
        }
    }
}

