/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class NestedNameCollision {
    @JsonProperty(value="collision")
    private final Collision collision;
    @JsonProperty(value="other")
    private final Other other;

    @JsonCreator
    private NestedNameCollision(@JsonProperty(value="collision") Collision collision, @JsonProperty(value="other") Other other) {
        this.collision = collision;
        this.other = other;
    }

    @ConstructorBinding
    public NestedNameCollision(Optional<Collision> collision, Optional<Other> other) {
        if (Globals.config().validateInConstructor().test(NestedNameCollision.class)) {
            Preconditions.checkNotNull(collision, (String)"collision");
            Preconditions.checkNotNull(other, (String)"other");
        }
        this.collision = collision.orElse(null);
        this.other = other.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Collision> collision() {
        return Optional.ofNullable(this.collision);
    }

    public Optional<Other> other() {
        return Optional.ofNullable(this.other);
    }

    public NestedNameCollision withCollision(Optional<Collision> collision) {
        return new NestedNameCollision(collision, Optional.ofNullable(this.other));
    }

    public NestedNameCollision withOther(Optional<Other> other) {
        return new NestedNameCollision(Optional.ofNullable(this.collision), other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedNameCollision other = (NestedNameCollision)o;
        return Objects.equals(this.collision, other.collision) && Objects.equals(this.other, other.other);
    }

    public int hashCode() {
        return Objects.hash(this.collision, this.other);
    }

    public String toString() {
        return Util.toString(NestedNameCollision.class, (Object[])new Object[]{"collision", this.collision, "other", this.other});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Other {
        @JsonProperty(value="collision")
        private final Collision collision;

        @JsonCreator
        private Other(@JsonProperty(value="collision") Collision collision) {
            this.collision = collision;
        }

        @ConstructorBinding
        public Other(Optional<Collision> collision) {
            if (Globals.config().validateInConstructor().test(Other.class)) {
                Preconditions.checkNotNull(collision, (String)"collision");
            }
            this.collision = collision.orElse(null);
        }

        public static Other collision(Optional<Collision> collision) {
            return new Other(collision);
        }

        public static Other collision(Collision collision) {
            return new Other(Optional.of(collision));
        }

        public Optional<Collision> collision() {
            return Optional.ofNullable(this.collision);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Other other = (Other)o;
            return Objects.equals(this.collision, other.collision);
        }

        public int hashCode() {
            return Objects.hash(this.collision);
        }

        public String toString() {
            return Util.toString(Other.class, (Object[])new Object[]{"collision", this.collision});
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
        public static final class Collision {
            @JsonProperty(value="b")
            private final String b;

            @JsonCreator
            private Collision(@JsonProperty(value="b") String b) {
                this.b = b;
            }

            @ConstructorBinding
            public Collision(Optional<String> b) {
                if (Globals.config().validateInConstructor().test(Collision.class)) {
                    Preconditions.checkNotNull(b, (String)"b");
                }
                this.b = b.orElse(null);
            }

            public static Collision b(Optional<String> b) {
                return new Collision(b);
            }

            public static Collision b(String b) {
                return new Collision(Optional.of(b));
            }

            public Optional<String> b() {
                return Optional.ofNullable(this.b);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Collision other = (Collision)o;
                return Objects.equals(this.b, other.b);
            }

            public int hashCode() {
                return Objects.hash(this.b);
            }

            public String toString() {
                return Util.toString(Collision.class, (Object[])new Object[]{"b", this.b});
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Collision {
        @JsonProperty(value="a")
        private final String a;

        @JsonCreator
        private Collision(@JsonProperty(value="a") String a) {
            this.a = a;
        }

        @ConstructorBinding
        public Collision(Optional<String> a) {
            if (Globals.config().validateInConstructor().test(Collision.class)) {
                Preconditions.checkNotNull(a, (String)"a");
            }
            this.a = a.orElse(null);
        }

        public static Collision a(Optional<String> a) {
            return new Collision(a);
        }

        public static Collision a(String a) {
            return new Collision(Optional.of(a));
        }

        public Optional<String> a() {
            return Optional.ofNullable(this.a);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Collision other = (Collision)o;
            return Objects.equals(this.a, other.a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return Util.toString(Collision.class, (Object[])new Object[]{"a", this.a});
        }
    }

    public static final class Builder {
        private Optional<Collision> collision = Optional.empty();
        private Optional<Other> other = Optional.empty();

        Builder() {
        }

        public Builder collision(Collision collision) {
            this.collision = Optional.of(collision);
            return this;
        }

        public Builder collision(Optional<Collision> collision) {
            this.collision = collision;
            return this;
        }

        public Builder other(Other other) {
            this.other = Optional.of(other);
            return this;
        }

        public Builder other(Optional<Other> other) {
            this.other = other;
            return this;
        }

        public NestedNameCollision build() {
            return new NestedNameCollision(this.collision, this.other);
        }
    }
}

