/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class NullableExample {
    @JsonProperty(value="req")
    private final JsonNullable<Integer> req;
    @JsonProperty(value="a")
    private final long a;
    @JsonProperty(value="notReq")
    private final JsonNullable<String> notReq;
    @JsonProperty(value="b")
    private final B b;

    @JsonCreator
    private NullableExample(@JsonProperty(value="req") JsonNullable<Integer> req, @JsonProperty(value="a") long a, @JsonProperty(value="notReq") JsonNullable<String> notReq, @JsonProperty(value="b") B b) {
        if (Globals.config().validateInConstructor().test(NullableExample.class)) {
            Preconditions.checkMinLength(notReq, (int)4, (String)"notReq");
        }
        this.req = req;
        this.a = a;
        this.notReq = notReq;
        this.b = b;
    }

    @ConstructorBinding
    public NullableExample(Optional<Integer> req, long a, JsonNullable<String> notReq, B b) {
        if (Globals.config().validateInConstructor().test(NullableExample.class)) {
            Preconditions.checkNotNull(notReq, (String)"notReq");
            Preconditions.checkMinLength(notReq, (int)4, (String)"notReq");
            Preconditions.checkNotNull((Object)((Object)b), (String)"b");
        }
        this.req = JsonNullable.of(req.orElse(null));
        this.a = a;
        this.notReq = notReq;
        this.b = b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Integer> req() {
        return Optional.ofNullable(this.req.get());
    }

    public long a() {
        return this.a;
    }

    public JsonNullable<String> notReq() {
        return this.notReq;
    }

    public B b() {
        return this.b;
    }

    public NullableExample withReq(Optional<Integer> req) {
        return new NullableExample(req, this.a, this.notReq, this.b);
    }

    public NullableExample withA(long a) {
        return new NullableExample(Optional.ofNullable(this.req.get()), a, this.notReq, this.b);
    }

    public NullableExample withNotReq(JsonNullable<String> notReq) {
        return new NullableExample(Optional.ofNullable(this.req.get()), this.a, (JsonNullable<String>)JsonNullable.of((Object)notReq.orElse(null)), this.b);
    }

    public NullableExample withB(B b) {
        return new NullableExample(Optional.ofNullable(this.req.get()), this.a, this.notReq, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableExample other = (NullableExample)o;
        return Objects.equals(this.req, other.req) && Objects.equals(this.a, other.a) && Objects.equals(this.notReq, other.notReq) && Objects.equals((Object)this.b, (Object)other.b);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.req, this.a, this.notReq, this.b});
    }

    public String toString() {
        return Util.toString(NullableExample.class, (Object[])new Object[]{"req", this.req, "a", this.a, "notReq", this.notReq, "b", this.b});
    }

    public static enum B {
        HELLO("hello"),
        THERE("there");

        @JsonValue
        private final String value;

        private B(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        @JsonCreator
        public static B fromValue(Object value) {
            for (B x : B.values()) {
                if (!Objects.equals(value, x.value)) continue;
                return x;
            }
            throw new IllegalArgumentException("unexpected enum value: '" + value + "'");
        }
    }

    public static final class BuilderWithB {
        private final Builder b;

        BuilderWithB(Builder b) {
            this.b = b;
        }

        public BuilderWithB req(int req) {
            this.b.req = Optional.of(req);
            return this;
        }

        public BuilderWithB req(Optional<Integer> req) {
            this.b.req = req;
            return this;
        }

        public BuilderWithB notReq(String notReq) {
            this.b.notReq = JsonNullable.of((Object)notReq);
            return this;
        }

        public BuilderWithB notReq(JsonNullable<String> notReq) {
            this.b.notReq = notReq;
            return this;
        }

        public NullableExample build() {
            return new NullableExample(this.b.req, this.b.a, (JsonNullable<String>)this.b.notReq, this.b.b);
        }
    }

    public static final class BuilderWithA {
        private final Builder b;

        BuilderWithA(Builder b) {
            this.b = b;
        }

        public BuilderWithB b(B b) {
            this.b.b = b;
            return new BuilderWithB(this.b);
        }
    }

    public static final class Builder {
        private long a;
        private B b;
        private Optional<Integer> req = Optional.empty();
        private JsonNullable<String> notReq = JsonNullable.undefined();

        Builder() {
        }

        public BuilderWithA a(long a) {
            this.a = a;
            return new BuilderWithA(this);
        }
    }
}

