/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class NullableMapPropertyNotAlone {
    @JsonProperty(value="thing")
    private final JsonNullable<Map<String, Object>> thing;
    @JsonProperty(value="other")
    private final String other;

    @JsonCreator
    private NullableMapPropertyNotAlone(@JsonProperty(value="thing") JsonNullable<Map<String, Object>> thing, @JsonProperty(value="other") String other) {
        this.thing = thing;
        this.other = other;
    }

    @ConstructorBinding
    public NullableMapPropertyNotAlone(JsonNullable<Map<String, Object>> thing, Optional<String> other) {
        if (Globals.config().validateInConstructor().test(NullableMapPropertyNotAlone.class)) {
            Preconditions.checkNotNull(thing, (String)"thing");
            Preconditions.checkNotNull(other, (String)"other");
        }
        this.thing = thing;
        this.other = other.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonNullable<Map<String, Object>> thing() {
        return this.thing;
    }

    public Optional<String> other() {
        return Optional.ofNullable(this.other);
    }

    public NullableMapPropertyNotAlone withThing(JsonNullable<Map<String, Object>> thing) {
        return new NullableMapPropertyNotAlone((JsonNullable<Map<String, Object>>)JsonNullable.of((Object)thing.orElse(null)), Optional.ofNullable(this.other));
    }

    public NullableMapPropertyNotAlone withOther(Optional<String> other) {
        return new NullableMapPropertyNotAlone(this.thing, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableMapPropertyNotAlone other = (NullableMapPropertyNotAlone)o;
        return Objects.equals(this.thing, other.thing) && Objects.equals(this.other, other.other);
    }

    public int hashCode() {
        return Objects.hash(this.thing, this.other);
    }

    public String toString() {
        return Util.toString(NullableMapPropertyNotAlone.class, (Object[])new Object[]{"thing", this.thing, "other", this.other});
    }

    public static final class Builder {
        private JsonNullable<Map<String, Object>> thing = JsonNullable.undefined();
        private Optional<String> other = Optional.empty();

        Builder() {
        }

        public Builder thing(JsonNullable<Map<String, Object>> thing) {
            this.thing = thing;
            return this;
        }

        public Builder other(String other) {
            this.other = Optional.of(other);
            return this;
        }

        public Builder other(Optional<String> other) {
            this.other = other;
            return this;
        }

        public NullableMapPropertyNotAlone build() {
            return new NullableMapPropertyNotAlone(this.thing, this.other);
        }
    }
}

