/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class ObjectAllOptionalFields {
    @JsonProperty(value="str")
    private final String str;
    @JsonProperty(value="num")
    private final Integer num;

    @JsonCreator
    private ObjectAllOptionalFields(@JsonProperty(value="str") String str, @JsonProperty(value="num") Integer num) {
        this.str = str;
        this.num = num;
    }

    @ConstructorBinding
    public ObjectAllOptionalFields(Optional<String> str, Optional<Integer> num) {
        if (Globals.config().validateInConstructor().test(ObjectAllOptionalFields.class)) {
            Preconditions.checkNotNull(str, (String)"str");
            Preconditions.checkNotNull(num, (String)"num");
        }
        this.str = str.orElse(null);
        this.num = num.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> str() {
        return Optional.ofNullable(this.str);
    }

    public Optional<Integer> num() {
        return Optional.ofNullable(this.num);
    }

    public ObjectAllOptionalFields withStr(Optional<String> str) {
        return new ObjectAllOptionalFields(str, Optional.ofNullable(this.num));
    }

    public ObjectAllOptionalFields withNum(Optional<Integer> num) {
        return new ObjectAllOptionalFields(Optional.ofNullable(this.str), num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectAllOptionalFields other = (ObjectAllOptionalFields)o;
        return Objects.equals(this.str, other.str) && Objects.equals(this.num, other.num);
    }

    public int hashCode() {
        return Objects.hash(this.str, this.num);
    }

    public String toString() {
        return Util.toString(ObjectAllOptionalFields.class, (Object[])new Object[]{"str", this.str, "num", this.num});
    }

    public static final class Builder {
        private Optional<String> str = Optional.empty();
        private Optional<Integer> num = Optional.empty();

        Builder() {
        }

        public Builder str(String str) {
            this.str = Optional.of(str);
            return this;
        }

        public Builder str(Optional<String> str) {
            this.str = str;
            return this;
        }

        public Builder num(int num) {
            this.num = Optional.of(num);
            return this;
        }

        public Builder num(Optional<Integer> num) {
            this.num = num;
            return this;
        }

        public ObjectAllOptionalFields build() {
            return new ObjectAllOptionalFields(this.str, this.num);
        }
    }
}

