/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Pattern {
    @JsonProperty(value="first")
    private final String first;
    @JsonProperty(value="second")
    private final String second;

    @JsonCreator
    private Pattern(@JsonProperty(value="first") String first, @JsonProperty(value="second") String second) {
        if (Globals.config().validateInConstructor().test(Pattern.class)) {
            Preconditions.checkMatchesPattern((String)first, (String)"a.*", (String)"first");
            Preconditions.checkMatchesPattern((String)second, (String)"b.*", (String)"second");
        }
        this.first = first;
        this.second = second;
    }

    @ConstructorBinding
    public Pattern(String first, Optional<String> second) {
        if (Globals.config().validateInConstructor().test(Pattern.class)) {
            Preconditions.checkNotNull((Object)first, (String)"first");
            Preconditions.checkMatchesPattern((String)first, (String)"a.*", (String)"first");
            Preconditions.checkNotNull(second, (String)"second");
            Preconditions.checkMatchesPattern(second, (String)"b.*", (String)"second");
        }
        this.first = first;
        this.second = second.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String first() {
        return this.first;
    }

    public Optional<String> second() {
        return Optional.ofNullable(this.second);
    }

    public Pattern withFirst(String first) {
        return new Pattern(first, Optional.ofNullable(this.second));
    }

    public Pattern withSecond(Optional<String> second) {
        return new Pattern(this.first, second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern other = (Pattern)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return Util.toString(Pattern.class, (Object[])new Object[]{"first", this.first, "second", this.second});
    }

    public static final class BuilderWithFirst {
        private final Builder b;

        BuilderWithFirst(Builder b) {
            this.b = b;
        }

        public BuilderWithFirst second(String second) {
            this.b.second = Optional.of(second);
            return this;
        }

        public BuilderWithFirst second(Optional<String> second) {
            this.b.second = second;
            return this;
        }

        public Pattern build() {
            return new Pattern(this.b.first, this.b.second);
        }
    }

    public static final class Builder {
        private String first;
        private Optional<String> second = Optional.empty();

        Builder() {
        }

        public BuilderWithFirst first(String first) {
            this.first = first;
            return new BuilderWithFirst(this);
        }
    }
}

