/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.NavOrPiracyBroadcastArea;
import org.davidmoten.oa3.codegen.test.main.schema.NonSARPriority;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class PiracyBroadcast {
    @JsonProperty(value="piracyBroadcastArea")
    private final NavOrPiracyBroadcastArea piracyBroadcastArea;
    @JsonProperty(value="priority")
    private final NonSARPriority priority;

    @JsonCreator
    @ConstructorBinding
    public PiracyBroadcast(@JsonProperty(value="piracyBroadcastArea") NavOrPiracyBroadcastArea piracyBroadcastArea, @JsonProperty(value="priority") NonSARPriority priority) {
        if (Globals.config().validateInConstructor().test(PiracyBroadcast.class)) {
            Preconditions.checkNotNull((Object)piracyBroadcastArea, (String)"piracyBroadcastArea");
            Preconditions.checkNotNull((Object)((Object)priority), (String)"priority");
        }
        this.piracyBroadcastArea = piracyBroadcastArea;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NavOrPiracyBroadcastArea piracyBroadcastArea() {
        return this.piracyBroadcastArea;
    }

    public NonSARPriority priority() {
        return this.priority;
    }

    public PiracyBroadcast withPiracyBroadcastArea(NavOrPiracyBroadcastArea piracyBroadcastArea) {
        return new PiracyBroadcast(piracyBroadcastArea, this.priority);
    }

    public PiracyBroadcast withPriority(NonSARPriority priority) {
        return new PiracyBroadcast(this.piracyBroadcastArea, priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiracyBroadcast other = (PiracyBroadcast)o;
        return Objects.equals(this.piracyBroadcastArea, other.piracyBroadcastArea) && Objects.equals((Object)this.priority, (Object)other.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.piracyBroadcastArea, this.priority});
    }

    public String toString() {
        return Util.toString(PiracyBroadcast.class, (Object[])new Object[]{"piracyBroadcastArea", this.piracyBroadcastArea, "priority", this.priority});
    }

    public static final class BuilderWithPriority {
        private final Builder b;

        BuilderWithPriority(Builder b) {
            this.b = b;
        }

        public PiracyBroadcast build() {
            return new PiracyBroadcast(this.b.piracyBroadcastArea, this.b.priority);
        }
    }

    public static final class BuilderWithPiracyBroadcastArea {
        private final Builder b;

        BuilderWithPiracyBroadcastArea(Builder b) {
            this.b = b;
        }

        public BuilderWithPriority priority(NonSARPriority priority) {
            this.b.priority = priority;
            return new BuilderWithPriority(this.b);
        }
    }

    public static final class Builder {
        private NavOrPiracyBroadcastArea piracyBroadcastArea;
        private NonSARPriority priority;

        Builder() {
        }

        public BuilderWithPiracyBroadcastArea piracyBroadcastArea(NavOrPiracyBroadcastArea piracyBroadcastArea) {
            this.piracyBroadcastArea = piracyBroadcastArea;
            return new BuilderWithPiracyBroadcastArea(this);
        }
    }
}

