/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class PropertyAnonymous {
    @JsonProperty(value="name")
    private final Name name;

    @JsonCreator
    private PropertyAnonymous(@JsonProperty(value="name") Name name) {
        this.name = name;
    }

    @ConstructorBinding
    public PropertyAnonymous(Optional<Name> name) {
        if (Globals.config().validateInConstructor().test(PropertyAnonymous.class)) {
            Preconditions.checkNotNull(name, (String)"name");
        }
        this.name = name.orElse(null);
    }

    public static PropertyAnonymous name(Optional<Name> name) {
        return new PropertyAnonymous(name);
    }

    public static PropertyAnonymous name(Name name) {
        return new PropertyAnonymous(Optional.of(name));
    }

    public Optional<Name> name() {
        return Optional.ofNullable(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyAnonymous other = (PropertyAnonymous)o;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return Util.toString(PropertyAnonymous.class, (Object[])new Object[]{"name", this.name});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class Name {
        @JsonProperty(value="first")
        private final String first;
        @JsonProperty(value="second")
        private final String second;

        @JsonCreator
        private Name(@JsonProperty(value="first") String first, @JsonProperty(value="second") String second) {
            this.first = first;
            this.second = second;
        }

        @ConstructorBinding
        public Name(Optional<String> first, Optional<String> second) {
            if (Globals.config().validateInConstructor().test(Name.class)) {
                Preconditions.checkNotNull(first, (String)"first");
                Preconditions.checkNotNull(second, (String)"second");
            }
            this.first = first.orElse(null);
            this.second = second.orElse(null);
        }

        public static Builder builder() {
            return new Builder();
        }

        public Optional<String> first() {
            return Optional.ofNullable(this.first);
        }

        public Optional<String> second() {
            return Optional.ofNullable(this.second);
        }

        public Name withFirst(Optional<String> first) {
            return new Name(first, Optional.ofNullable(this.second));
        }

        public Name withSecond(Optional<String> second) {
            return new Name(Optional.ofNullable(this.first), second);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name other = (Name)o;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return Util.toString(Name.class, (Object[])new Object[]{"first", this.first, "second", this.second});
        }

        public static final class Builder {
            private Optional<String> first = Optional.empty();
            private Optional<String> second = Optional.empty();

            Builder() {
            }

            public Builder first(String first) {
                this.first = Optional.of(first);
                return this;
            }

            public Builder first(Optional<String> first) {
                this.first = first;
                return this;
            }

            public Builder second(String second) {
                this.second = Optional.of(second);
                return this;
            }

            public Builder second(Optional<String> second) {
                this.second = second;
                return this;
            }

            public Name build() {
                return new Name(this.first, this.second);
            }
        }
    }
}

