/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class PropertyBytesNotRequired {
    @JsonProperty(value="one")
    private final byte[] one;
    @JsonProperty(value="two")
    private final String two;

    @JsonCreator
    private PropertyBytesNotRequired(@JsonProperty(value="one") byte[] one, @JsonProperty(value="two") String two) {
        this.one = one;
        this.two = two;
    }

    @ConstructorBinding
    public PropertyBytesNotRequired(Optional<byte[]> one, Optional<byte[]> two) {
        if (Globals.config().validateInConstructor().test(PropertyBytesNotRequired.class)) {
            Preconditions.checkNotNull(two, (String)"two");
        }
        this.one = one.orElse(null);
        this.two = Util.encodeOctets(two);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<byte[]> one() {
        return Optional.ofNullable(this.one);
    }

    public Optional<byte[]> two() {
        return Optional.ofNullable(Util.decodeOctets((String)this.two));
    }

    public PropertyBytesNotRequired withOne(Optional<byte[]> one) {
        return new PropertyBytesNotRequired(one, Optional.ofNullable(Util.decodeOctets((String)this.two)));
    }

    public PropertyBytesNotRequired withTwo(Optional<byte[]> two) {
        return new PropertyBytesNotRequired(Optional.ofNullable(this.one), two);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBytesNotRequired other = (PropertyBytesNotRequired)o;
        return Objects.equals(this.one, other.one) && Objects.equals(this.two, other.two);
    }

    public int hashCode() {
        return Objects.hash(this.one, this.two);
    }

    public String toString() {
        return Util.toString(PropertyBytesNotRequired.class, (Object[])new Object[]{"one", this.one, "two", this.two});
    }

    public static final class Builder {
        private Optional<byte[]> one = Optional.empty();
        private Optional<byte[]> two = Optional.empty();

        Builder() {
        }

        public Builder one(byte[] one) {
            this.one = Optional.of(one);
            return this;
        }

        public Builder one(Optional<byte[]> one) {
            this.one = one;
            return this;
        }

        public Builder two(byte[] two) {
            this.two = Optional.of(two);
            return this;
        }

        public Builder two(Optional<byte[]> two) {
            this.two = two;
            return this;
        }

        public PropertyBytesNotRequired build() {
            return new PropertyBytesNotRequired(this.one, this.two);
        }
    }
}

