/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class PropertyBytesRequired {
    @JsonProperty(value="one")
    private final byte[] one;
    @JsonProperty(value="two")
    private final String two;

    @JsonCreator
    private PropertyBytesRequired(@JsonProperty(value="one") byte[] one, @JsonProperty(value="two") String two) {
        this.one = one;
        this.two = two;
    }

    @ConstructorBinding
    public PropertyBytesRequired(byte[] one, byte[] two) {
        if (Globals.config().validateInConstructor().test(PropertyBytesRequired.class)) {
            Preconditions.checkNotNull((Object)two, (String)"two");
        }
        this.one = one;
        this.two = Util.encodeOctets((byte[])two);
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] one() {
        return this.one;
    }

    public byte[] two() {
        return Util.decodeOctets((String)this.two);
    }

    public PropertyBytesRequired withOne(byte[] one) {
        return new PropertyBytesRequired(one, this.two);
    }

    public PropertyBytesRequired withTwo(byte[] two) {
        return new PropertyBytesRequired(this.one, two);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyBytesRequired other = (PropertyBytesRequired)o;
        return Objects.equals(this.one, other.one) && Objects.equals(this.two, other.two);
    }

    public int hashCode() {
        return Objects.hash(this.one, this.two);
    }

    public String toString() {
        return Util.toString(PropertyBytesRequired.class, (Object[])new Object[]{"one", this.one, "two", this.two});
    }

    public static final class BuilderWithTwo {
        private final Builder b;

        BuilderWithTwo(Builder b) {
            this.b = b;
        }

        public PropertyBytesRequired build() {
            return new PropertyBytesRequired(this.b.one, this.b.two);
        }
    }

    public static final class BuilderWithOne {
        private final Builder b;

        BuilderWithOne(Builder b) {
            this.b = b;
        }

        public BuilderWithTwo two(byte[] two) {
            Builder.access$002(this.b, two);
            return new BuilderWithTwo(this.b);
        }
    }

    public static final class Builder {
        private byte[] one;
        private byte[] two;

        Builder() {
        }

        public BuilderWithOne one(byte[] one) {
            this.one = one;
            return new BuilderWithOne(this);
        }

        static /* synthetic */ byte[] access$002(Builder x0, byte[] x1) {
            x0.two = x1;
            return x1;
        }
    }
}

