/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.Latitude;
import org.davidmoten.oa3.codegen.test.main.schema.Longitude;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Rectangle {
    @JsonProperty(value="minLat")
    private final Latitude minLat;
    @JsonProperty(value="leftLon")
    private final Longitude leftLon;
    @JsonProperty(value="heightDegrees")
    private final float heightDegrees;
    @JsonProperty(value="widthDegrees")
    private final float widthDegrees;

    @JsonCreator
    @ConstructorBinding
    public Rectangle(@JsonProperty(value="minLat") Latitude minLat, @JsonProperty(value="leftLon") Longitude leftLon, @JsonProperty(value="heightDegrees") float heightDegrees, @JsonProperty(value="widthDegrees") float widthDegrees) {
        if (Globals.config().validateInConstructor().test(Rectangle.class)) {
            Preconditions.checkNotNull((Object)minLat, (String)"minLat");
            Preconditions.checkNotNull((Object)leftLon, (String)"leftLon");
            Preconditions.checkMinimum((Number)Float.valueOf(heightDegrees), (String)"0", (String)"heightDegrees", (boolean)true);
            Preconditions.checkMaximum((Number)Float.valueOf(heightDegrees), (String)"180", (String)"heightDegrees", (boolean)false);
            Preconditions.checkMinimum((Number)Float.valueOf(widthDegrees), (String)"0", (String)"widthDegrees", (boolean)true);
            Preconditions.checkMaximum((Number)Float.valueOf(widthDegrees), (String)"360", (String)"widthDegrees", (boolean)false);
        }
        this.minLat = minLat;
        this.leftLon = leftLon;
        this.heightDegrees = heightDegrees;
        this.widthDegrees = widthDegrees;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Latitude minLat() {
        return this.minLat;
    }

    public Longitude leftLon() {
        return this.leftLon;
    }

    public float heightDegrees() {
        return this.heightDegrees;
    }

    public float widthDegrees() {
        return this.widthDegrees;
    }

    public Rectangle withMinLat(Latitude minLat) {
        return new Rectangle(minLat, this.leftLon, this.heightDegrees, this.widthDegrees);
    }

    public Rectangle withLeftLon(Longitude leftLon) {
        return new Rectangle(this.minLat, leftLon, this.heightDegrees, this.widthDegrees);
    }

    public Rectangle withHeightDegrees(float heightDegrees) {
        return new Rectangle(this.minLat, this.leftLon, heightDegrees, this.widthDegrees);
    }

    public Rectangle withWidthDegrees(float widthDegrees) {
        return new Rectangle(this.minLat, this.leftLon, this.heightDegrees, widthDegrees);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        return Objects.equals(this.minLat, other.minLat) && Objects.equals(this.leftLon, other.leftLon) && Objects.equals(Float.valueOf(this.heightDegrees), Float.valueOf(other.heightDegrees)) && Objects.equals(Float.valueOf(this.widthDegrees), Float.valueOf(other.widthDegrees));
    }

    public int hashCode() {
        return Objects.hash(this.minLat, this.leftLon, Float.valueOf(this.heightDegrees), Float.valueOf(this.widthDegrees));
    }

    public String toString() {
        return Util.toString(Rectangle.class, (Object[])new Object[]{"minLat", this.minLat, "leftLon", this.leftLon, "heightDegrees", Float.valueOf(this.heightDegrees), "widthDegrees", Float.valueOf(this.widthDegrees)});
    }

    public static final class BuilderWithWidthDegrees {
        private final Builder b;

        BuilderWithWidthDegrees(Builder b) {
            this.b = b;
        }

        public Rectangle build() {
            return new Rectangle(this.b.minLat, this.b.leftLon, this.b.heightDegrees, this.b.widthDegrees);
        }
    }

    public static final class BuilderWithHeightDegrees {
        private final Builder b;

        BuilderWithHeightDegrees(Builder b) {
            this.b = b;
        }

        public BuilderWithWidthDegrees widthDegrees(float widthDegrees) {
            this.b.widthDegrees = widthDegrees;
            return new BuilderWithWidthDegrees(this.b);
        }
    }

    public static final class BuilderWithLeftLon {
        private final Builder b;

        BuilderWithLeftLon(Builder b) {
            this.b = b;
        }

        public BuilderWithHeightDegrees heightDegrees(float heightDegrees) {
            this.b.heightDegrees = heightDegrees;
            return new BuilderWithHeightDegrees(this.b);
        }
    }

    public static final class BuilderWithMinLat {
        private final Builder b;

        BuilderWithMinLat(Builder b) {
            this.b = b;
        }

        public BuilderWithLeftLon leftLon(Longitude leftLon) {
            this.b.leftLon = leftLon;
            return new BuilderWithLeftLon(this.b);
        }
    }

    public static final class Builder {
        private Latitude minLat;
        private Longitude leftLon;
        private float heightDegrees;
        private float widthDegrees;

        Builder() {
        }

        public BuilderWithMinLat minLat(Latitude minLat) {
            this.minLat = minLat;
            return new BuilderWithMinLat(this);
        }
    }
}

