/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.IntervalHours;
import org.davidmoten.oa3.codegen.test.main.schema.NumRepetitions;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class Repetition {
    @JsonProperty(value="number")
    private final NumRepetitions number;
    @JsonProperty(value="intervalHours")
    private final IntervalHours intervalHours;

    @JsonCreator
    @ConstructorBinding
    public Repetition(@JsonProperty(value="number") NumRepetitions number, @JsonProperty(value="intervalHours") IntervalHours intervalHours) {
        if (Globals.config().validateInConstructor().test(Repetition.class)) {
            Preconditions.checkNotNull((Object)((Object)number), (String)"number");
            Preconditions.checkNotNull((Object)((Object)intervalHours), (String)"intervalHours");
        }
        this.number = number;
        this.intervalHours = intervalHours;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NumRepetitions number() {
        return this.number;
    }

    public IntervalHours intervalHours() {
        return this.intervalHours;
    }

    public Repetition withNumber(NumRepetitions number) {
        return new Repetition(number, this.intervalHours);
    }

    public Repetition withIntervalHours(IntervalHours intervalHours) {
        return new Repetition(this.number, intervalHours);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repetition other = (Repetition)o;
        return Objects.equals((Object)this.number, (Object)other.number) && Objects.equals((Object)this.intervalHours, (Object)other.intervalHours);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.intervalHours});
    }

    public String toString() {
        return Util.toString(Repetition.class, (Object[])new Object[]{"number", this.number, "intervalHours", this.intervalHours});
    }

    public static final class BuilderWithIntervalHours {
        private final Builder b;

        BuilderWithIntervalHours(Builder b) {
            this.b = b;
        }

        public Repetition build() {
            return new Repetition(this.b.number, this.b.intervalHours);
        }
    }

    public static final class BuilderWithNumber {
        private final Builder b;

        BuilderWithNumber(Builder b) {
            this.b = b;
        }

        public BuilderWithIntervalHours intervalHours(IntervalHours intervalHours) {
            this.b.intervalHours = intervalHours;
            return new BuilderWithIntervalHours(this.b);
        }
    }

    public static final class Builder {
        private NumRepetitions number;
        private IntervalHours intervalHours;

        Builder() {
        }

        public BuilderWithNumber number(NumRepetitions number) {
            this.number = number;
            return new BuilderWithNumber(this);
        }
    }
}

