/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.test.main.schema.SARBroadcastArea;
import org.davidmoten.oa3.codegen.test.main.schema.SARPriority;
import org.davidmoten.oa3.codegen.test.main.schema.SARServiceType;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class SARBroadcast {
    @JsonProperty(value="sarArea")
    private final SARBroadcastArea sarArea;
    @JsonProperty(value="serviceType")
    private final SARServiceType serviceType;
    @JsonProperty(value="priority")
    private final SARPriority priority;

    @JsonCreator
    private SARBroadcast(@JsonProperty(value="sarArea") SARBroadcastArea sarArea, @JsonProperty(value="serviceType") SARServiceType serviceType, @JsonProperty(value="priority") SARPriority priority) {
        this.sarArea = sarArea;
        this.serviceType = serviceType;
        this.priority = priority;
    }

    @ConstructorBinding
    public SARBroadcast(Optional<SARBroadcastArea> sarArea, SARServiceType serviceType, SARPriority priority) {
        if (Globals.config().validateInConstructor().test(SARBroadcast.class)) {
            Preconditions.checkNotNull(sarArea, (String)"sarArea");
            Preconditions.checkNotNull((Object)((Object)serviceType), (String)"serviceType");
            Preconditions.checkNotNull((Object)((Object)priority), (String)"priority");
        }
        this.sarArea = sarArea.orElse(null);
        this.serviceType = serviceType;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<SARBroadcastArea> sarArea() {
        return Optional.ofNullable(this.sarArea);
    }

    public SARServiceType serviceType() {
        return this.serviceType;
    }

    public SARPriority priority() {
        return this.priority;
    }

    public SARBroadcast withSarArea(Optional<SARBroadcastArea> sarArea) {
        return new SARBroadcast(sarArea, this.serviceType, this.priority);
    }

    public SARBroadcast withServiceType(SARServiceType serviceType) {
        return new SARBroadcast(Optional.ofNullable(this.sarArea), serviceType, this.priority);
    }

    public SARBroadcast withPriority(SARPriority priority) {
        return new SARBroadcast(Optional.ofNullable(this.sarArea), this.serviceType, priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SARBroadcast other = (SARBroadcast)o;
        return Objects.equals(this.sarArea, other.sarArea) && Objects.equals((Object)this.serviceType, (Object)other.serviceType) && Objects.equals((Object)this.priority, (Object)other.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sarArea, this.serviceType, this.priority});
    }

    public String toString() {
        return Util.toString(SARBroadcast.class, (Object[])new Object[]{"sarArea", this.sarArea, "serviceType", this.serviceType, "priority", this.priority});
    }

    public static final class BuilderWithPriority {
        private final Builder b;

        BuilderWithPriority(Builder b) {
            this.b = b;
        }

        public BuilderWithPriority sarArea(SARBroadcastArea sarArea) {
            this.b.sarArea = Optional.of(sarArea);
            return this;
        }

        public BuilderWithPriority sarArea(Optional<SARBroadcastArea> sarArea) {
            this.b.sarArea = sarArea;
            return this;
        }

        public SARBroadcast build() {
            return new SARBroadcast(this.b.sarArea, this.b.serviceType, this.b.priority);
        }
    }

    public static final class BuilderWithServiceType {
        private final Builder b;

        BuilderWithServiceType(Builder b) {
            this.b = b;
        }

        public BuilderWithPriority priority(SARPriority priority) {
            this.b.priority = priority;
            return new BuilderWithPriority(this.b);
        }
    }

    public static final class Builder {
        private SARServiceType serviceType;
        private SARPriority priority;
        private Optional<SARBroadcastArea> sarArea = Optional.empty();

        Builder() {
        }

        public BuilderWithServiceType serviceType(SARServiceType serviceType) {
            this.serviceType = serviceType;
            return new BuilderWithServiceType(this);
        }
    }
}

