/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.test.main.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.test.main.Globals;
import org.davidmoten.oa3.codegen.util.Util;
import org.springframework.boot.context.properties.ConstructorBinding;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, creatorVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.ANY)
public final class TwoMaps {
    @JsonProperty(value="stuff")
    private final Map<String, Object> stuff;
    @JsonProperty(value="other")
    private final Map<String, Object> other;

    @JsonCreator
    private TwoMaps(@JsonProperty(value="stuff") Map<String, Object> stuff, @JsonProperty(value="other") Map<String, Object> other) {
        this.stuff = stuff;
        this.other = other;
    }

    @ConstructorBinding
    public TwoMaps(Optional<Map<String, Object>> stuff, Optional<Map<String, Object>> other) {
        if (Globals.config().validateInConstructor().test(TwoMaps.class)) {
            Preconditions.checkNotNull(stuff, (String)"stuff");
            Preconditions.checkNotNull(other, (String)"other");
        }
        this.stuff = stuff.orElse(null);
        this.other = other.orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Map<String, Object>> stuff() {
        return Optional.ofNullable(this.stuff);
    }

    public Optional<Map<String, Object>> other() {
        return Optional.ofNullable(this.other);
    }

    public TwoMaps withStuff(Optional<Map<String, Object>> stuff) {
        return new TwoMaps(stuff, Optional.ofNullable(this.other));
    }

    public TwoMaps withOther(Optional<Map<String, Object>> other) {
        return new TwoMaps(Optional.ofNullable(this.stuff), other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwoMaps other = (TwoMaps)o;
        return Objects.equals(this.stuff, other.stuff) && Objects.equals(this.other, other.other);
    }

    public int hashCode() {
        return Objects.hash(this.stuff, this.other);
    }

    public String toString() {
        return Util.toString(TwoMaps.class, (Object[])new Object[]{"stuff", this.stuff, "other", this.other});
    }

    public static final class Builder {
        private Optional<Map<String, Object>> stuff = Optional.empty();
        private Optional<Map<String, Object>> other = Optional.empty();

        Builder() {
        }

        public Builder stuff(Optional<Map<String, Object>> stuff) {
            this.stuff = stuff;
            return this;
        }

        public Builder other(Optional<Map<String, Object>> other) {
            this.other = other;
            return this;
        }

        public TwoMaps build() {
            return new TwoMaps(this.stuff, this.other);
        }
    }
}

